//
//  EmailCleanListController.swift
//  PhoneManager
//
//  Created by edy on 2025/5/9.
//

import UIKit

class EmailCleanListController: BaseViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = .white
        NotificationCenter.default.addObserver(self, selector: #selector(uupddate), name: messageUpdate, object: nil)
    }
    
    @objc func uupddate() -> Void {
        DispatchQueue.main.async {
            self.datasoure = PMEmailManager.shareManager.allMessage[self.indexPath?.row ?? 0].child
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        titleView.model.isBackBtnShow = true
        tableView.indexPath = indexPath
        datasoure = PMEmailManager.shareManager.allMessage[indexPath?.row ?? 0].child
        setup()
    }
    
    var indexPath:IndexPath?
    
    var datasoure:[EmailMessageModel] = [] {
        didSet {
            tableView.datasource = datasoure
            seletedAllBtn.isHidden = !(datasoure.count > 0)
            seletedAllBtn.isSelected = EmailFilterManager.share.SelectEmailSet[indexPath?.row ?? 0].count == datasoure.count
        }
    }
    
    @objc func seletedAllBtnClick() {
        DispatchQueue.main.async {[weak self] in
            guard let self  else {return}
            tableView.changeSelectAll(seletedAllBtn.isSelected)
        }
    }
    
    private func setup() -> Void {
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(titleView.snp.bottom).offset(20)
            make.left.equalToSuperview().offset(marginLR)
        }
        tableView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(titleLabel.snp.bottom).offset(10)
            make.bottom.equalToSuperview()
        }
        titleView.addSubview(seletedAllBtn)
        seletedAllBtn.snp.makeConstraints { make in
            make.right.equalToSuperview().inset(marginLR)
            make.height.equalTo(32)
            make.centerY.equalTo(titleView.backBtn.snp.centerY)
        }
    }
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = ""
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        label.textColor = UIColor.colorWithHex(hexStr: "#333333")
        label.textAlignment = .left
        view.addSubview(label)
        return label
    }()
    
    private lazy var tableView: EmailCleanListView = {
        let tab = EmailCleanListView()
        view.addSubview(tab)
        tab.callblock = { [weak self] select in
            guard let self = self else { return }
            self.seletedAllBtn.isSelected = select
        }
        tab.callBlur = { [weak self] show in
            guard let self = self else { return }
            if show {
                self.view.showBlur()
            }else{
                self.view.hideBlur()
            }
        }
        return tab
    }()
    
    private lazy var seletedAllBtn:SelectAllButton = {
        let view = SelectAllButton()
        view.clipsToBounds = true
        view.layer.cornerRadius = 16
        view.tapCallback = {[weak self] isselect in
            self?.seletedAllBtnClick()
        }
        return view
//        let btn:UIButton = UIButton(frame: CGRect(x: 0, y: 0, width: 115, height: 32))
//        btn.addTarget(self, action: #selector(seletedAllBtnClick), for: .touchUpInside)
//        btn.backgroundColor = UIColor.colorWithHex(hexStr: "#F2F6FC")
//        btn.setImage(UIImage.init(named: "ic_check_similar"), for: .normal)
//        btn.setTitle("Select All", for: .normal)
//        btn.setImage(UIImage.init(named: "ic_close_similar"), for: .selected)
//        btn.setTitle("Unselect all", for: .selected)
//        btn.setTitleColor(UIColor.colorWithHex(hexStr: mColor), for: .normal)
//        btn.setTitleColor(UIColor.colorWithHex(hexStr: black3Color), for: .selected)
//        btn.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .bold)
//        btn.layer.cornerRadius = btn.height / 2
//        btn.layer.masksToBounds = true
//        btn.changBtnWithStytl(btnStyle: .defalut, margin: 8)
//        return btn
    }()
}
