//
//  EmailContentDelAlert.swift
//  PhoneManager
//
//  Created by edy on 2025/5/9.
//

import UIKit


class EmailContentDelAlert: UIViewController, UIViewControllerTransitioningDelegate {
    
    enum EmailStateAlert {
        case group
        case list
        case emailSignOut
        case emailApply
        case endCompress
    }
    
    var callblock:((Int)->Void) = { idx in}
    
    var endCompressCallback:((Int)->Void) = {idx in}
    
    
    var state:EmailStateAlert = .group
    
    @IBOutlet weak var EmailContentMessage: UILabel!
    @IBOutlet weak var EmailContentAction1: UIButton!
    @IBOutlet weak var EmailContentAction2: UIButton!
    
    @IBOutlet weak var tipsLabel: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.transitioningDelegate = self
        view.backgroundColor = .clear //UIColor.colorWithHex(hexStr: "#000000", alpha: 0.5)
        switch state {
        case .group:
            EmailContentMessage.text = "Are you sure you want to delete\nthe selected message?"
            EmailContentAction1.setTitle("Delete", for: .normal)
            EmailContentAction2.setTitle("Cancel", for: .normal)
            tipsLabel.text = "This process cannot be revoked!"
            break
        case .list:
            EmailContentMessage.text = "Are you sure you want to delete\nthe selected message?"
            EmailContentAction1.setTitle("Delete", for: .normal)
            EmailContentAction2.setTitle("Cancel", for: .normal)
            break
        case .emailSignOut:
            EmailContentMessage.text = "Are you sure you want to quit？"
            EmailContentAction1.setTitle("Yes", for: .normal)
            EmailContentAction2.setTitle("Cancel", for: .normal)
            break
        case .emailApply:
            EmailContentMessage.text = "Are you sure you want to apply filters?"
            EmailContentAction1.setTitle("Yes", for: .normal)
            EmailContentAction2.setTitle("Cancel", for: .normal)
            break
        case .endCompress:
            EmailContentMessage.text = "Would you like to stop compressing?"
            EmailContentAction1.setTitle("Keep Compressing", for: .normal)
            EmailContentAction2.setTitle("Stop Compressing", for: .normal)
            tipsLabel.text = "If you stop now you won't get the results"
            break
        }
        
    }
    
    func animationController(forDismissed dismissed: UIViewController) -> UIViewControllerAnimatedTransitioning? {
        return customDismissAnimator()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
    }

    func show() -> Void {
        self.modalPresentationStyle = .overFullScreen
        UIViewController.topMostViewController()?.present(self, animated: true)
    }
    
    @IBAction func openAction(_ sender: Any) {
        self.dismiss(animated: true) {
            self.callblock(1)
        }
    }
    
    @IBAction func delMails(_ sender: Any) {
        callblock(2)
        self.dismiss(animated: true) {
            self.endCompressCallback(2)
        }
    }
    
    init(state:EmailStateAlert) {
        super.init(nibName: nil, bundle: nil)
        self.state = state
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
}
