//
//  EmailFilterSelectCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/9.
//

import UIKit

class EmailFilterSelectCell: UITableViewCell {

    static let id = "EmailFilterSelectCell"
    
    @IBOutlet weak var selectBtn: UIButton!
    @IBOutlet weak var titleL: UILabel!
    
    @IBOutlet weak var lineW: UIView!
    var callblock:((Bool)->Void) = { select in}
    
    var top:Bool = false
    var bot:Bool = false
    
    func reload() -> Void {
        DispatchQueue.main.async {
            self.lineW.isHidden = true
            if self.top && self.bot {
                self.cornerCut(radius: 12, corner: [.allCorners])
            }else if self.top {
                self.cornerCut(radius: 12, corner: [.topLeft,.topRight])
            }else if self.bot {
                self.lineW.isHidden = true
                self.cornerCut(radius: 12, corner: [.bottomLeft,.bottomRight])
            }else{
                self.cornerCut(radius: 0, corner: [.allCorners])
            }
        }
    }
    
    @IBAction func selectActions(_ sender: UIButton) {
        if sender.isSelected {
            return
        }
        sender.isSelected = true
        callblock(sender.isSelected)
    }
}
