//
//  WidgetBornThenView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/8.
//

import UIKit

class WidgetBornThenView: UIView ,BatteryStatusDelegate {

    var widgetMode = 0 {
        didSet{
            if widgetMode == 0 {
                shapeLayer.strokeColor = UIColor.colorWithHex(hexStr: "#FFFFFF").cgColor
                BatteryLayer.strokeColor = UIColor.colorWithHex(hexStr: "#FFFFFF").cgColor
                clayer.backgroundColor = UIColor.colorWithHex(hexStr: "#0082FF").cgColor
                layer.shadowColor = UIColor.colorWithHex(hexStr: "#0082FF").cgColor
                widgetT.textColor = .white
                widgetR.textColor = .white
                widgetS.textColor = .white
                
                BatteryT.textColor = .white
                BatteryR.textColor = .white
                BatteryU.textColor = WidgetPublicModel.BatteryState() ? UIColor.white : UIColor(hex: "#cccccc")
                BatteryS.textColor = WidgetPublicModel.isLowPowerModeEnabled() ? UIColor.white : UIColor(hex: "#cccccc")
            }else if widgetMode == 1 {
                shapeLayer.strokeColor = UIColor.colorWithHex(hexStr: "#0082FF").cgColor
                BatteryLayer.strokeColor = UIColor.colorWithHex(hexStr: "#0082FF").cgColor
                clayer.backgroundColor = UIColor.colorWithHex(hexStr: "#333333").cgColor
                layer.shadowColor = UIColor.colorWithHex(hexStr: "#333333").cgColor
                widgetT.textColor = .white
                widgetR.textColor = .white
                widgetS.textColor = UIColor(hex: "#4AE2FF")
                
                BatteryT.textColor = .white
                BatteryR.textColor = .white
                BatteryU.textColor = WidgetPublicModel.BatteryState() ? UIColor(hex: "#4AE2FF") : UIColor(hex: "#cccccc")
                BatteryS.textColor = WidgetPublicModel.isLowPowerModeEnabled() ? UIColor(hex: "#4AE2FF") : UIColor(hex: "#cccccc")
            }else{
                shapeLayer.strokeColor = UIColor.colorWithHex(hexStr: "#0082FF").cgColor
                BatteryLayer.strokeColor = UIColor.colorWithHex(hexStr: "#0082FF").cgColor
                layer.shadowColor = UIColor.colorWithHex(hexStr: "#CCE6FF").cgColor
                clayer.backgroundColor = UIColor.white.cgColor
                widgetT.textColor = .black
                widgetR.textColor = .black
                widgetS.textColor = UIColor.colorWithHex(hexStr: "#0082FF")
                
                BatteryT.textColor = .black
                BatteryR.textColor = .black
                BatteryU.textColor = WidgetPublicModel.BatteryState() ? UIColor.colorWithHex(hexStr: "#0082FF") : UIColor(hex: "#cccccc")
                BatteryS.textColor = WidgetPublicModel.isLowPowerModeEnabled() ? UIColor(hex: "#666666") : UIColor(hex: "#cccccc")
            }
            setWidgetInfo()
            setBattInfo()
        }
    }
    
    private func setWidgetInfo() -> Void {
        self.layoutIfNeeded()
        if widgetMode != 2 {
            widgetInfo.image = UIImage(named: "img_storage_widgets")
        }else{
            widgetInfo.image = UIImage(named: "img_storage_widgets_b")
        }
        let path = UIBezierPath()
        let size:CGSize = widgetInfo.bounds.size
        var endangle:CGFloat = 0
        let useP:CGFloat = WidgetPublicModel.UseDiskSpace()
        endangle = -.pi/2.0 + CGFloat(Double.pi * 2.0 * useP)
        path.addArc(withCenter: CGPoint(x: size.width/2.0, y: size.height/2.0),
                    radius: size.width / 2.0 - 3,
                    startAngle: -Double.pi/2.0,
                    endAngle: endangle,
                    clockwise: true)
        shapeLayer.path = path.cgPath
        widgetR.text = String(format: "%d%%", Int(round(useP*100)))
        let disk = WidgetPublicModel.getDiskSpace()
        let allInt = Int(CGFloat(disk.0)/(1000.0 * 1000.0 * 1000.0))
        let useInt = Int(CGFloat(disk.0 - disk.1)/(1000.0 * 1000.0 * 1000.0))
        
        let all = String(format: "%d" ,allInt)
        let use = String(format: "%d" ,useInt)
        let text = "\(use) of \(all) GB"
        widgetS.text = text
    }
    
    private func setBattInfo() -> Void {
        self.layoutIfNeeded()
        if widgetMode != 2 {
            BatteryInfo.image = UIImage(named: "img_battery_widgets")
        }else{
            BatteryInfo.image = UIImage(named: "img_battery_widgets_b")
        }
        let path1 = UIBezierPath()
        let size1:CGSize = BatteryInfo.bounds.size
        var endangle1:CGFloat = 0
        let end1:CGFloat = CGFloat(WidgetPublicModel.battery() / 100.0)
        endangle1 = -Double.pi/2.0 + CGFloat(Double.pi * 2.0 * end1)
        path1.addArc(withCenter: CGPoint(x: size1.width/2.0, y: size1.height/2.0),
                    radius: size1.width / 2.0 - 3,
                    startAngle: -Double.pi/2.0,
                    endAngle: endangle1,
                    clockwise: true)
        BatteryLayer.path = path1.cgPath
        BatteryR.text = String(format: "%.0f%%", WidgetPublicModel.battery() )
        BatteryS.text = "Low Power Mode " + (WidgetPublicModel.isLowPowerModeEnabled() ? "On" : "Off")
        
        BatteryU.text = WidgetPublicModel.BatteryState() ? "Charging now" : "No action"
    }
    
    
    private func setup() -> Void {
        widgetInfo.layer.addSublayer(shapeLayer)
        BatteryInfo.layer.addSublayer(BatteryLayer)
        widgetT.snp.makeConstraints { make in
            make.left.equalTo(widgetR.snp.left)
            make.bottom.equalTo(widgetR.snp.top).offset(-2)
        }
        widgetR.snp.makeConstraints { make in
            make.left.equalToSuperview().inset(marginLR)
            make.bottom.equalTo(self.widgetInfo.snp.centerY).offset(-1)
        }
        widgetU.snp.makeConstraints { make in
            make.left.equalTo(widgetR.snp.left)
            make.top.equalTo(widgetR.snp.bottom).offset(2)
        }
        widgetS.snp.makeConstraints { make in
            make.left.equalTo(widgetR.snp.left)
            make.top.equalTo(widgetU.snp.bottom).offset(2)
        }
        
        BatteryT.snp.makeConstraints { make in
            make.left.equalTo(BatteryR.snp.left)
            make.bottom.equalTo(BatteryR.snp.top).offset(-2)
        }
        BatteryR.snp.makeConstraints { make in
            make.left.equalToSuperview().inset(marginLR)
            make.bottom.equalTo(self.BatteryInfo.snp.centerY).offset(-1)
        }
        BatteryU.snp.makeConstraints { make in
            make.left.equalTo(BatteryR.snp.left)
            make.top.equalTo(BatteryR.snp.bottom).offset(2)
        }
        BatteryS.snp.makeConstraints { make in
            make.left.equalTo(BatteryR.snp.left)
            make.top.equalTo(BatteryU.snp.bottom).offset(2)
        }
        
        widgetInfo.snp.makeConstraints { make in
            make.top.equalToSuperview().inset(30)
            make.right.equalToSuperview().inset(20)
            make.bottom.equalTo(self.snp.centerY).offset(-30)
            make.width.equalTo(widgetInfo.snp.height)
        }
        BatteryInfo.snp.makeConstraints { make in
            make.top.equalTo(self.snp.centerY).offset(30)
            make.right.equalTo(widgetInfo.snp.right)
            make.bottom.equalToSuperview().inset(30)
            make.width.equalTo(BatteryInfo.snp.height)
        }

        self.layoutIfNeeded()
        shapeLayer.frame = widgetInfo.bounds
        BatteryLayer.frame = BatteryInfo.bounds
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        BatteryMonitorManager.shared.delegate = self
        layer.insertSublayer(clayer, at: 0)
        setup()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
        setup()
    }

    func batteryStatusDidUpdate(level: Float, state: UIDevice.BatteryState) {
        setBattInfo()
    }
    
    private lazy var widgetT: UILabel = {
        let l = UILabel()
        l.font = UIFont.systemFont(ofSize: 18)
        l.text = "Storage"
        addSubview(l)
        return l
    }()
    
    private lazy var widgetR: UILabel = {
        let r = UILabel()
        r.font = UIFont.boldSystemFont(ofSize: 20)
        addSubview(r)
        return r
    }()
    
    private lazy var widgetU: UILabel = {
        let l = UILabel()
        l.font = UIFont.boldSystemFont(ofSize: 20)
        l.text = "Used"
        l.textColor = UIColor(hex: "#cccccc")
        addSubview(l)
        return l
    }()
    
    private lazy var widgetS: UILabel = {
        let l = UILabel()
        l.font = UIFont.boldSystemFont(ofSize: 18)
        addSubview(l)
        return l
    }()
    
    
    
    private lazy var BatteryT: UILabel = {
        let l = UILabel()
        l.font = UIFont.systemFont(ofSize: 18)
        l.text = "Battery"
        addSubview(l)
        return l
    }()
    
    private lazy var BatteryR: UILabel = {
        let r = UILabel()
        r.font = UIFont.boldSystemFont(ofSize: 20)
        addSubview(r)
        return r
    }()
    
    private lazy var BatteryU: UILabel = {
        let l = UILabel()
        l.font = UIFont.boldSystemFont(ofSize: 20)
        l.text = "No action"
        l.textColor = UIColor(hex: "#cccccc")
        addSubview(l)
        return l
    }()
    
    private lazy var BatteryS: UILabel = {
        let l = UILabel()
        l.font = UIFont.systemFont(ofSize: 18)
        l.textColor = UIColor(hex: "#cccccc")
        l.text = "Low Power Mode Off"
        addSubview(l)
        return l
    }()
    
    
    
    private lazy var clayer: CALayer = {
        let l = CALayer()
        l.backgroundColor = UIColor.white.cgColor
        l.cornerRadius = 20
        return l
    }()
    
    override func layoutSubviews() {
        super.layoutSubviews()
        clayer.frame = self.bounds
        layer.shadowOffset = CGSize(width: 3, height: 3)
        layer.shadowOpacity = 0.7
        layer.shadowRadius = 20.0
        layer.shadowPath = UIBezierPath(rect: bounds).cgPath
        shapeLayer.zPosition = 10
        BatteryLayer.zPosition = 10
    }
    
    private lazy var widgetInfo: UIImageView = {
        let info = UIImageView()
        addSubview(info)
        info.contentMode = .scaleToFill
        return info
    }()
    
    private lazy var shapeLayer: CAShapeLayer = {
        let sh = CAShapeLayer()
        sh.fillColor = UIColor.clear.cgColor
        sh.lineWidth = 8
        sh.lineCap = .round
        return sh
    }()
    
    private lazy var BatteryInfo: UIImageView = {
        let info = UIImageView()
        addSubview(info)
        info.contentMode = .scaleToFill
        return info
    }()
    
    private lazy var BatteryLayer: CAShapeLayer = {
        let sh = CAShapeLayer()
        sh.fillColor = UIColor.clear.cgColor
        sh.lineWidth = 8
        sh.lineCap = .round
        return sh
    }()
}
