//
//  TrashContenTitleCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/11.
//

import UIKit





class TrashContenTitleCell: UICollectionViewCell {

    @IBOutlet weak var title: UILabel!
    @IBOutlet weak var contentL: UILabel!
    
    var lineOne: UIView!
    var lineTwo: UIView!
    var lineThree: UIView!
    var lineFour: UIView!
    
    var scrollLine:UIView!
    
    
    let lineW:CGFloat = (ScreenW - 62) / 4.0
    
    let selectColor:UIColor = UIColor.colorWithHex(hexStr: "#0082FF")
    
    let normalColor:UIColor = UIColor.colorWithHex(hexStr: "#E5E5E5")
    
    var trashType:TrashTypeEnum = .video{
        didSet{
            switch trashType {
            case .video:
                scrollLine.frame = lineOne.frame
            case .other:
                scrollLine.frame = lineTwo.frame
            case .shot:
                scrollLine.frame = lineThree.frame
            }
        }
    }
        
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        lineOne = UIView()
        lineOne.backgroundColor = UIColor.colorWithHex(hexStr: "#E5E5E5")
        addSubview(lineOne)
        
        lineTwo = UIView()
        lineTwo.backgroundColor = UIColor.colorWithHex(hexStr: "#E5E5E5")
        addSubview(lineTwo)
        
        lineThree = UIView()
        lineThree.backgroundColor = UIColor.colorWithHex(hexStr: "#E5E5E5")
        addSubview(lineThree)
        
        lineFour = UIView()
        lineFour.backgroundColor = UIColor.colorWithHex(hexStr: "#E5E5E5")
        addSubview(lineFour)
        
        lineOne.frame = CGRect(x: 16, y: 62, width: lineW, height: 6)
        lineTwo.frame = CGRect(x: 10+lineOne.rightX, y: 62, width: lineW, height: 6)
        lineThree.frame = CGRect(x: 10+lineTwo.rightX, y: 62, width: lineW, height: 6)
        lineFour.frame = CGRect(x: 10+lineThree.rightX, y: 62, width: lineW, height: 6)
        
       
        scrollLine = UIView()
        scrollLine.backgroundColor = UIColor.colorWithHex(hexStr: "#0082FF")
        scrollLine.frame = lineOne.frame
        addSubview(scrollLine)
        

        scrollLine.cornerCut(radius: 2, corner: .allCorners)
        
        NotificationCenter.default.addObserver(forName: .trashPageScroll, object: nil, queue: nil) {[weak self] notif in
            guard let weakSelf = self else { return }
            guard let offset = notif.object as? CGFloat else{
                return
            }
           
            switch weakSelf.trashType {
            case .video:
                if offset > 0{
                    UIView.animate(withDuration: 0.2) {
                        weakSelf.scrollLine.frame = weakSelf.lineTwo.frame
                    }
                }else{
                    UIView.animate(withDuration: 0.2) {
                        weakSelf.scrollLine.frame = weakSelf.lineOne.frame
                    }
                }
       
            case .other:
                if offset > ScreenW{
                    UIView.animate(withDuration: 0.2) {
                        weakSelf.scrollLine.frame = weakSelf.lineThree.frame
                    }
                }
                else if offset == ScreenW{
                    UIView.animate(withDuration: 0.2) {
                        weakSelf.scrollLine.frame = weakSelf.lineTwo.frame
                    }
                }
                else{
                    UIView.animate(withDuration: 0.2) {
                        weakSelf.scrollLine.frame = weakSelf.lineOne.frame
                    }
                }
       
            case .shot:
                if offset > ScreenW * 2{
                    UIView.animate(withDuration: 0.2) {
                        weakSelf.scrollLine.frame = weakSelf.lineFour.frame
                    }
                }
                else if offset == ScreenW * 2{
                    UIView.animate(withDuration: 0.2) {
                        weakSelf.scrollLine.frame = weakSelf.lineThree.frame
                    }
                }
                else{
                    UIView.animate(withDuration: 0.2) {
                        weakSelf.scrollLine.frame = weakSelf.lineTwo.frame
                    }
                }
                
            }
        }
    }

    override func layoutSubviews() {
        super.layoutSubviews()
         
    }
    
//    func reset(){
//        lineOne.backgroundColor = trashType.normalColor
//        lineTwo.backgroundColor = trashType.normalColor
//        lineThree.backgroundColor = trashType.normalColor
//        lineFour.backgroundColor = trashType.normalColor
//    }
}
