//
//  TipsVideoPhotoController.swift
//  PhoneManager
//
//  Created by edy on 2025/4/27.
//

import UIKit

class TipsVideoPhotoController: UIViewController {

    @IBOutlet weak var startBtn: UIButton!
    @IBOutlet weak var mainTitle: UILabel!
    @IBOutlet weak var icon: UIImageView!
    @IBOutlet weak var subtitle: UILabel!
    
    @IBOutlet weak var bottomC: NSLayoutConstraint!
    var type:GuideTipsType = .duplicates
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        startBtn.layer.cornerRadius = 23
        
        icon.image = UIImage.init(named: type.tipOneIcon)
        
        mainTitle.text = type.title
        subtitle.text = type.text
        
        bottomC.constant = kSafeAreaInsets.bottom == 0 ? 30 : 0
  
    }

    @IBAction func startClick(_ sender: Any) {
        
        self.dismiss(animated: true)
    }
    
   

}
