//
//  GuideTipsModel.swift
//  PhoneManager
//
//  Created by edy on 2025/4/27.
//

import Foundation


enum GuideTipsType{
    
    case duplicates,similar,video,photo
    
}

extension GuideTipsType{
    
    var tipOneIcon:String{
        switch self {
        case .duplicates:
            return "tips_duplicates_1"
        case .similar:
            return "tips_similar_1"
        case .video:
            return "tips_video"
        case .photo:
            return "tips_photos"
        }
    }
    
    var tipTwoIcon:String{
        switch self {
        case .duplicates:
            return "tips_duplicates_2"
        case .similar:
            return "tips_similar_2"
        case .video:
            return ""
        case .photo:
            return ""
        }
    }
    
    var title:String{
        switch self {
        case .duplicates:
            return "Duplicates"
        case .similar:
            return "Similar photos"
        case .video:
            return "Video"
        case .photo:
            return "Photo"
        }
    }
    
    var lineText:String{
        switch self {
        case .duplicates:
            return "2 Duplicates"
        case .similar:
            return ""
        case .video:
            return ""
        case .photo:
            return ""
        }
    }
    
    var text:String{
        switch self {
        case .duplicates:
            return "These are duplicate photos - they are completely identical to each other. Immediately delete all duplicate items and keep the original version."
        case .similar:
            return "We will group similar photos together and provide recommendations for the best photos. Please safely view and select the photos you want to move to the trash can."
        case .video:
            return "View all of your videos. Sort them by size or date. View the video that occupies the maximum space."
        case .photo:
            return "These are photos that do not belong to any category. Sort them by size or date. Delete unnecessary photos."
        }
    }
}


struct TipsManager{
    
    static func saveLoadStatus(_ type:PhotsFileType){
        let key = "isFirstShow_\(type.rawValue)"
        UserDefaults.standard.set(true, forKey:key)
        UserDefaults.standard.synchronize()
    }
    
    static func getLoadStauts(_ type:PhotsFileType) ->Bool{
        let key = "isFirstShow_\(type.rawValue)"
        if let show = UserDefaults.standard.value(forKey: key) as? Bool{
            return show
        }
        return false
    }
}
