//
//  SettingSwitchCell.swift
//  PhoneManager
//
//  Created by edy on 2025/3/31.
//

import Foundation

class SettingSwitchCell : UITableViewCell {
    
    var data:RowInfoModel? {
        didSet {
            guard let dict = data else { return }
            DispatchQueue.main.async {
                self.fLabel.text = dict.title
                self.logoView.image = UIImage(named: dict.imageName)
                if dict.title == settingLabels.UsePIN.rawValue {
                    self.openImageView.isSelected = SettingConfiguration.share.config.secret?.count ?? 0 == 4
                }else if dict.title == settingLabels.UseFaceID.rawValue {
                    self.openImageView.isSelected = SettingConfiguration.share.config.faceId ?? false
                }else if dict.title == settingLabels.RemoveAfterImport.rawValue {
                    self.openImageView.isSelected = SettingConfiguration.share.config.removeImg
                }else if dict.title == settingLabels.Vibration.rawValue {
                    self.openImageView.isSelected = SettingConfiguration.share.config.vibration ?? false
                }else{
                    
                }
            }
        }
    }
    
    override var frame: CGRect{
        didSet{
            var newFrame = frame
            newFrame.origin.x += 15
            newFrame.size.width -= 30
            super.frame = newFrame
        }
    }
    
    lazy var lineView : UIView = {
        let lineView = UIView()
        lineView.backgroundColor = .white
        return lineView
    }()
    
    lazy var logoView : UIImageView = {
        let logoView = UIImageView()
        logoView.backgroundColor = .clear
        return logoView
        
    }()
    
    lazy var fLabel : UILabel = {
        let label = UILabel();
        label.text = "ceshi"
        label.font = UIFont.systemFont(ofSize: 16, weight: .semibold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .left
        return label
    }()
    
    lazy var openImageView : UIButton = {
        let sview:UIButton = UIButton(type: .custom)
        sview.backgroundColor = .clear
        sview.isUserInteractionEnabled = false
        sview.setImage(UIImage(named: "icon_set_secret_Off"), for: .normal)
        sview.setImage(UIImage(named: "icon_set_secret_On"), for: .selected)
        return sview
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        self.selectionStyle = .none
        self.contentView.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        self.contentView.addSubview(self.logoView)
        self.contentView.addSubview(self.fLabel)
        self.contentView.addSubview(self.openImageView)
        self.contentView.addSubview(self.lineView)
        
        self.logoView.snp.makeConstraints { make in
            make.width.height.equalTo(28)
            make.left.equalToSuperview().offset(16)
            make.centerY.equalToSuperview()
        }
        
        self.fLabel.snp.makeConstraints { make in
            make.left.equalTo(self.logoView.snp.right).offset(16)
            make.top.equalToSuperview()
            make.height.equalTo(60)
            make.width.equalTo(206)
            make.bottom.equalToSuperview()
        }
        self.openImageView.snp.makeConstraints { make in
            make.height.equalTo(28)
            make.width.equalTo(36)
            make.right.equalToSuperview().offset(-16)
            make.centerY.equalToSuperview()
        }
        self.lineView.snp.makeConstraints { make in
            make.height.equalTo(1)
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.bottom.equalToSuperview().offset(-1)
        }
        self.clipsToBounds = true
    }
    
    
    required init?(coder: NSCoder) {
        super .init(coder: coder)
        fatalError("init(coder:) has not been implemented")
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
    }
    
}
