//
//  SettingNormalCell.swift
//  PhoneManager
//
//  Created by edy on 2025/3/31.
//

import Foundation

class SettingNormalCell : UITableViewCell {
    
    override var frame: CGRect {
        didSet{
            var newFrame = frame
            newFrame.origin.x += 15
            newFrame.size.width -= 30
            super.frame = newFrame
        }
    }
    
    lazy var lineView : UIView = {
        let lineView = UIView()
        lineView.backgroundColor = .white
        return lineView
    }()
    
    lazy var logoView : UIImageView = {
        let logoView = UIImageView()
        logoView.backgroundColor = .clear
        return logoView
        
    }()
    
    lazy var fLabel : UILabel = {
        let label = UILabel();
        label.text = "ceshi"
        label.font = UIFont.systemFont(ofSize: 16, weight: .semibold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .left
        return label
    }()
    lazy var moreImageView : UIImageView = {
        let sview:UIImageView = UIImageView()
        sview.backgroundColor = .clear
        sview.image = UIImage(named: "icon_left_setting_grey")
        return sview
    }()
    
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        self.selectionStyle = .none
        self.contentView.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        self.contentView.addSubview(self.logoView)
        self.contentView.addSubview(self.fLabel)
        self.contentView.addSubview(self.moreImageView)
        self.contentView.addSubview(self.lineView)
    
        
        self.logoView.snp.makeConstraints { make in
            make.width.height.equalTo(28)
            make.left.equalToSuperview().offset(16)
            make.centerY.equalToSuperview()
        }
        
        self.fLabel.snp.makeConstraints { make in
            make.left.equalTo(self.logoView.snp.right).offset(16)
            make.top.equalToSuperview()
            make.height.equalTo(60)
            make.bottom.equalToSuperview()
            make.width.equalTo(206)
        }
        self.moreImageView.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.right.equalToSuperview().offset(-16)
            make.centerY.equalToSuperview()
        }
        self.lineView.snp.makeConstraints { make in
            make.height.equalTo(1)
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.bottom.equalToSuperview().offset(-1)
        }
        
    }
    
    
    required init?(coder: NSCoder) {
        super .init(coder: coder)
        fatalError("init(coder:) has not been implemented")
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
    }
    
}
