//
//  SettingModel.swift
//  PhoneManager
//
//  Created by edy on 2025/3/31.
//

import Foundation

enum settingLabels : String {

case Email  = "Log in"
case UsePIN  = "Use PIN"
case UseFaceID  = "Use Face ID"
case ChangePIN  = "Change PIN"
case RemoveAfterImport  = "Remove After Import"
case Widgets  = "Widgets"
case FollowonInstagram  = "Follow on Instagram"
case RateUs  = "Rate Us"
case ShareUs  = "Share Us"
case Hint  = "Hint"
case KeepList  = "Keep List"
case Vibration  = "Vibration"
case Resumepurchase  = "Resume purchase"
case EmailSupport  = "Email Support"
case FAQ  = "FAQ"
case AboutUs  = "About Us"
case PrivacyPolicy  = "Privacy Policy"
    
}

struct SettingModel {
    var sectionTitle: String
    var rowInfo : [RowInfoModel]
    init(sectionTitle: String, rowInfo: [RowInfoModel]) {
        self.sectionTitle = sectionTitle
        self.rowInfo = rowInfo
    }
}


struct settingConfigMode:Codable {
    var secret:String?
    var faceId:Bool?
    var removeImg:Bool = true
    var vibration:Bool?
}

struct RowInfoModel{
    var imageName : String
    var selectimageName : String?
    var title: String
    var isSwitch:Bool = false
    init(imageName: String, selectimageName: String? = nil, title: String, isSwitch: Bool = false) {
        self.imageName = imageName
        self.selectimageName = selectimageName
        self.title = title
        self.isSwitch = isSwitch
    }
}

func getSettingViewInfo() -> [SettingModel] {
    
    if SettingConfiguration.share.config.secret?.count ?? 0 != 4 {
        return [
            SettingModel(sectionTitle: "",rowInfo: [RowInfoModel(imageName: "",title: "")]),
            
//            SettingModel(sectionTitle: "E-mail",rowInfo: [RowInfoModel(imageName: "icon_set_secret_Email_l", title: "Log in")]),
            
            
            SettingModel(sectionTitle: "Secret space",rowInfo: [RowInfoModel(imageName: "icon_set_secret_lock",title: "Use PIN" , isSwitch:true),
                                                                RowInfoModel(imageName: "icon_set_secret_Del",title: "Remove After Import",isSwitch:true)]),
            
            
            SettingModel(sectionTitle: "Practical tools",rowInfo: [RowInfoModel(imageName: "icon_set_secret_Email_l", title: "Widgets")]),
            
            
            SettingModel(sectionTitle: "Stay in touch",rowInfo: [RowInfoModel(imageName: "icon_set_secret_ins_setting", title: "Follow on Instagram"),
                                                                 RowInfoModel(imageName: "icon_set_secret_rate_setting", title: "Rate Us"),
                                                                 RowInfoModel(imageName: "icon_set_secret_share_setting", title: "Share Us"),]),
            
            
            SettingModel(sectionTitle: "Other",rowInfo: [RowInfoModel(imageName: "icon_set_secret_Hint", title: "Hint"),
                                                         RowInfoModel(imageName: "icon_set_secret_keep", title: "Keep List"),
                                                         RowInfoModel(imageName: "icon_set_secret__vibration_setting", title: "Vibration",isSwitch:true)]),
            
            SettingModel(sectionTitle: "Support",rowInfo: [RowInfoModel(imageName: "icon_set_secret_restore", title: "Resume purchase"),
                                                           RowInfoModel(imageName: "icon_set_secret_Email_support", title: "Email Support"),
                                                           RowInfoModel(imageName: "icon_set_secret_FAQ", title: "FAQ"),
                                                           RowInfoModel(imageName: "icon_set_secret_about_us", title: "About Us"),
                                                           RowInfoModel(imageName: "icon_set_secret_Privacy", title: "Privacy Policy"),]),]
    } else {
        if PMFaceIDManger.isAvailable() {
            return [
                SettingModel(sectionTitle: "",rowInfo: [RowInfoModel(imageName: "",title: "")]),
                
//                SettingModel(sectionTitle: "E-mail",rowInfo: [RowInfoModel(imageName: "icon_set_secret_Email_l", title: "Log in")]),
                
                
                SettingModel(sectionTitle: "Secret space",rowInfo: [RowInfoModel(imageName: "icon_set_secret_lock",title: "Use PIN" , isSwitch:true),
                                                                    RowInfoModel(imageName: "icon_set_secret_Face",title: "Use Face ID",isSwitch:true),
                                                                    RowInfoModel(imageName: "icon_set_secret_ChangePin",title: "Change PIN"),
                                                                    RowInfoModel(imageName: "icon_set_secret_Del",title: "Remove After Import",isSwitch:true)]),
                
                
                SettingModel(sectionTitle: "Practical tools",rowInfo: [RowInfoModel(imageName: "icon_set_secret_Email_l", title: "Widgets")]),
                
                
                SettingModel(sectionTitle: "Stay in touch",rowInfo: [RowInfoModel(imageName: "icon_set_secret_ins_setting", title: "Follow on Instagram"),
                                                                     RowInfoModel(imageName: "icon_set_secret_rate_setting", title: "Rate Us"),
                                                                     RowInfoModel(imageName: "icon_set_secret_share_setting", title: "Share Us"),]),
                
                
                SettingModel(sectionTitle: "Other",rowInfo: [RowInfoModel(imageName: "icon_set_secret_Hint", title: "Hint"),
                                                             RowInfoModel(imageName: "icon_set_secret_keep", title: "Keep List"),
                                                             RowInfoModel(imageName: "icon_set_secret__vibration_setting", title: "Vibration",isSwitch:true)]),
                
                SettingModel(sectionTitle: "Support",rowInfo: [RowInfoModel(imageName: "icon_set_secret_restore", title: "Resume purchase"),
                                                               RowInfoModel(imageName: "icon_set_secret_Email_support", title: "Email Support"),
                                                               RowInfoModel(imageName: "icon_set_secret_FAQ", title: "FAQ"),
                                                               RowInfoModel(imageName: "icon_set_secret_about_us", title: "About Us"),
                                                               RowInfoModel(imageName: "icon_set_secret_Privacy", title: "Privacy Policy"),]),
            ]
        }else{
            return [
                SettingModel(sectionTitle: "",rowInfo: [RowInfoModel(imageName: "",title: "")]),
                
//                SettingModel(sectionTitle: "E-mail",rowInfo: [RowInfoModel(imageName: "icon_set_secret_Email_l", title: "Log in")]),
                
                
                SettingModel(sectionTitle: "Secret space",rowInfo: [RowInfoModel(imageName: "icon_set_secret_lock",title: "Use PIN" , isSwitch:true),
                                                                    RowInfoModel(imageName: "icon_set_secret_ChangePin",title: "Change PIN"),
                                                                    RowInfoModel(imageName: "icon_set_secret_Del",title: "Remove After Import",isSwitch:true)]),
                
                
                SettingModel(sectionTitle: "Practical tools",rowInfo: [RowInfoModel(imageName: "icon_set_secret_Email_l", title: "Widgets")]),
                
                
                SettingModel(sectionTitle: "Stay in touch",rowInfo: [RowInfoModel(imageName: "icon_set_secret_ins_setting", title: "Follow on Instagram"),
                                                                     RowInfoModel(imageName: "icon_set_secret_rate_setting", title: "Rate Us"),
                                                                     RowInfoModel(imageName: "icon_set_secret_share_setting", title: "Share Us"),]),
                
                
                SettingModel(sectionTitle: "Other",rowInfo: [RowInfoModel(imageName: "icon_set_secret_Hint", title: "Hint"),
                                                             RowInfoModel(imageName: "icon_set_secret_keep", title: "Keep List"),
                                                             RowInfoModel(imageName: "icon_set_secret__vibration_setting", title: "Vibration",isSwitch:true)]),
                
                SettingModel(sectionTitle: "Support",rowInfo: [RowInfoModel(imageName: "icon_set_secret_restore", title: "Resume purchase"),
                                                               RowInfoModel(imageName: "icon_set_secret_Email_support", title: "Email Support"),
                                                               RowInfoModel(imageName: "icon_set_secret_FAQ", title: "FAQ"),
                                                               RowInfoModel(imageName: "icon_set_secret_about_us", title: "About Us"),
                                                               RowInfoModel(imageName: "icon_set_secret_Privacy", title: "Privacy Policy"),]),]
        }
    }
}

class SettingConfiguration: NSObject {
    
    static let share = SettingConfiguration()
    
    var config:settingConfigMode = settingConfigMode()
    
    private func path() -> URL? {
        guard var path = FileManager.default.urls(for: .documentDirectory, in: .userDomainMask).first else { return nil}
        path = path.appendingPathComponent("settingcConfigs")
        return path
    }
    
    func initData() -> Void {
        guard let path = path() else {
            return
        }
        do {
            let dataFile = try Data(contentsOf: path)
            let decode = try JSONDecoder().decode(settingConfigMode.self, from:dataFile)
            config = decode
            return
        } catch { }
    }
    
    func saveData() -> Void {
        guard let path = path() else { return }
        do{
            let data = try JSONEncoder().encode(config)
            try data.write(to: path)
        } catch { }
    }
    
}
