//
//  SecretAlert.swift
//  PhoneManager
//
//  Created by edy on 2025/3/31.
//

import UIKit

class SecretAlert: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .colorWithHex(hexStr: "#000000", alpha: 0.7)
        setUI()
    }
    
    var callback:((_ idx:Int)->Void)?
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.modalTransitionStyle = .crossDissolve
        self.modalPresentationStyle = .overFullScreen
    }
    
    private func setUI() -> Void {
        view.addSubview(showView)
        showView.addSubview(showInfo)
        showView.addSubview(showTitle)
        showView.addSubview(showDesc)
        showView.addSubview(createPin)
        showView.addSubview(maybe)
        showView.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(15)
            make.centerY.equalToSuperview()
        }
        showInfo.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalToSuperview().offset(32)
        }
        showTitle.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(showInfo.snp.bottom).offset(16)
            make.left.right.equalToSuperview().inset(35)
        }
        showDesc.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(20)
            make.top.equalTo(showTitle.snp.bottom).offset(8)
            make.centerX.equalToSuperview()
        }
        createPin.snp.makeConstraints { make in
            make.top.equalTo(showDesc.snp.bottom).offset(16)
            make.left.right.equalToSuperview().inset(20)
            make.height.equalTo(46)
        }
        maybe.snp.makeConstraints { make in
            make.top.equalTo(createPin.snp.bottom).offset(16)
            make.left.right.equalTo(createPin)
            make.height.equalTo(46)
            make.bottom.equalToSuperview().offset(-20)
        }
    }
    
    func show() -> Void {
        guard let root = cWindow?.rootViewController else { return }
        self.modalPresentationStyle = .overFullScreen
        self.modalTransitionStyle = .crossDissolve
        root.present(self, animated: true)
    }
    
    @objc func creatPinTouch() -> Void {
        guard (callback != nil) else { return }
        callback!(1)
    }
    
    @objc func maybeTouch() -> Void {
        guard (callback != nil) else { return }
        callback!(0)
    }
    
    private lazy var createPin: UIButton = {
        let btn = UIButton(type: .custom)
        btn.backgroundColor = .colorWithHex(hexStr: "#0082FF")
        btn.setTitle("Create PlN", for: .normal)
        btn.titleLabel?.font = UIFont.systemFont(ofSize: 16)
        btn.layer.cornerRadius = 46/2.0
        btn.clipsToBounds = true
        btn.setTitleColor(.white, for: .normal)
        btn.addTarget(self, action: #selector(creatPinTouch), for: .touchUpInside)
        return btn
    }()
    
    private lazy var maybe: UIButton = {
        let btn = UIButton(type: .custom)
        btn.backgroundColor = .white
        btn.setTitle("Maybe Later", for: .normal)
        btn.titleLabel?.font = UIFont.systemFont(ofSize: 16)
        btn.setTitleColor(.colorWithHex(hexStr: "#666666"), for: .normal)
        btn.addTarget(self, action: #selector(maybeTouch), for: .touchUpInside)
        return btn
    }()
    
    private lazy var showView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 12;
        v.clipsToBounds = true
        return v
    }()
    
    private lazy var showInfo : UIImageView = {
        let info = UIImageView(image: UIImage(named: "img_secret_pop"))
        info.contentMode = .scaleToFill
        return info
    }()
    
    private lazy var showTitle: UILabel = {
        let l = UILabel()
        l.font = UIFont.boldSystemFont(ofSize: 20)
        l.text = "This is your Secret Library!"
        l.textAlignment = .center
        l.textColor = .colorWithHex(hexStr: "#1A1A1A")
        return l
    }()
    
    private lazy var showDesc: UILabel = {
        let d = UILabel()
        d.text = "Protect your private photos and videos by creating PIN."
        d.textColor = .colorWithHex(hexStr: "#666666")
        d.numberOfLines = 0
        d.font = UIFont.systemFont(ofSize: 14)
        d.textAlignment = .center
        d.numberOfLines = 0
        return d
    }()
    
}
