//
//  SecretImageCache.swift
//  PhoneManager
//
//  Created by edy on 2025/4/9.
//

import UIKit

class SecretImageCache: NSObject {
    
    private var imageCache:[String:UIImage] = [:]
    private var VideoCache:[String:Float64] = [:]
    
    func loadCacheImage(_ nm:String) -> (UIImage?,Float64)? {
        let duration:Float64 = self.VideoCache[nm] ?? -1
        if let image = self.imageCache[nm] {
            return (image,duration)
        }
        return nil
    }
    
    func removeAllImage() -> Void {
        self.imageCache.removeAll()
        self.VideoCache.removeAll()
    }
    
    func removeImage(_ nm:String) -> Void {
        self.imageCache.removeValue(forKey: nm)
        self.VideoCache.removeValue(forKey: nm)
    }
    
    func saveImageCache(_ nm:String ,_ image:UIImage ,_ duration:Float64 = -1) -> Void {
        self.imageCache[nm] = image
        if duration > 0 {
            self.VideoCache[nm] = duration
        }
    }
    
    static let share = SecretImageCache()
}
