//
//  PMShowVideoCell.swift
//  PhoneManager
//
//  Created by edy on 2025/4/9.
//

import UIKit

let PMShowVideoCellID = "PMShowVideoCell"

class PMShowVideoCell: UICollectionViewCell {
    
    var playURL:String = ""
    
    var homeResouceUrl : URL?
    
    var type : Int = 0
    
    var innerVideoController : VideoViewController?
    
    func reload() -> Void {
        var url : URL?
        if type == 0 {
            url = "SecretIm".document().appendingPathComponent(playURL)
        }else{
            url = homeResouceUrl
        }
        if let url = url {
            self.innerVideoController = VideoViewController()
            if let vc = self.innerVideoController {
                vc.url = url
                self.contentView.addSubview(vc.view)
                self.contentView.bringSubviewToFront(self.selectBtn)
                self.contentView.bringSubviewToFront(self.bestResultButton)
                vc.view.snp.makeConstraints { make in
                    make.left.top.bottom.right.equalToSuperview()
                }
            }
        }
        selectBtn.snp.updateConstraints { make in
//            if type == 0 {
//                make.bottom.equalToSuperview().offset(-10)
//            }else{
                make.bottom.equalToSuperview().offset(-40)
//            }
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.contentView.addSubview(self.selectBtn)
        selectBtn.snp.makeConstraints { make in
            make.right.equalToSuperview().inset(25)
            make.width.height.equalTo(iconWH)
            make.bottom.equalToSuperview().offset(-10)
        }
        bestResultButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.top.equalToSuperview().offset(34)
            make.width.equalTo(63)
            make.height.equalTo(21)
        }
        self.contentView.bringSubviewToFront(self.bestResultButton)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var zPlayer : SecretVideoPlayer {
        get {
            return player
        }
    }
    
    private lazy var player: SecretVideoPlayer = {
        let p = SecretVideoPlayer()
        p.layer.cornerRadius = 8
        p.clipsToBounds = true
        contentView.addSubview(p)
        return p
    }()
    
    var callblock:(()->Void) = {}
    
    @objc private func selectTap() -> Void {
        callblock()
    }
    
    var isCurrent:Bool = false {
        didSet {
            selectBtn.isSelected = isCurrent
        }
    }
 
    lazy var selectBtn: UIButton = {
        let select = UIButton(type: .custom)
        select.setImage(UIImage(named: "Frame_1318"), for: .normal)
        select.setImage(UIImage(named: "重复项说明-icon-选中 1"), for: .selected)
        select.addTarget(self, action: #selector(selectTap), for: .touchUpInside)
        contentView.addSubview(select)
        return select
    }()
    
    lazy var bestResultButton:UIButton = {
       
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "Frame"), for: .normal)
        button.setTitle("Best", for: .normal)
        button.setTitleColor(.white, for: .normal)
        button.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .semibold)
        button.layer.cornerRadius = 10.5
        button.clipsToBounds = true
        button.backgroundColor = UIColor(red: 1, green: 0.65, blue: 0, alpha: 1)
        contentView.addSubview(button)
        return button
        
    }()
}




