//
//  PMShowItemCell.swift
//  PhoneManager
//
//  Created by edy on 2025/4/10.
//

import UIKit


let PMShowItemCellID = "PMShowItemCell"

class PMShowItemCell: UICollectionViewCell {
    
    var isCurrent:Bool = false {
        didSet {
            selectBtn.isSelected = isCurrent
        }
    }
    
    var icon:UIImage? {
        didSet {
            iconV.image = icon
        }
    }
    
    var model:ImageSeletedCollectionItem?{
        didSet{
            guard let model = model else{
                return
            }
            
            if let id = model.id?.localIdentifier{
                iconV.asset.load(withLocalIdentifier: id)
            }
            
        }
    }
    
    private lazy var iconV: UIImageView = {
        let ic = UIImageView()
        ic.contentMode = .scaleAspectFill
        contentView.addSubview(ic)
        return ic
    }()
    
    lazy var selectBtn: UIButton = {
        let select = UIButton(type: .custom)
        select.setImage(UIImage(named: "Frame 7"), for: .normal)
        select.setImage(UIImage(named: "Frame 8"), for: .selected)
        contentView.addSubview(select)
        select.isUserInteractionEnabled = false
        return select
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        clipsToBounds = true
        self.layer.cornerRadius = 12
        setup()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setup() -> Void {
        iconV.snp.makeConstraints { make in
            make.left.right.top.bottom.equalToSuperview()
        }
        selectBtn.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.width.height.equalTo(iconWH)
            make.bottom.equalToSuperview()
        }
    }
    
}
