//
//  DelSuccessViewController.swift
//  PhoneManager
//
//  Created by edy on 2025/4/27.
//

import UIKit
import Photos
import Lottie

class DelSuccessViewController: UIViewController {
    
    @IBOutlet weak var bottomBtn: UIButton!
    @IBOutlet weak var bottomText: UILabel!
    @IBOutlet weak var points: UILabel!
    @IBOutlet weak var delText: UILabel!
    
    @IBOutlet weak var conTitle: UILabel!
    
    var closeCall:(()->Void) = {}
    
    var delType:String = "photo"
    
    var fileCount:Int = 0
    var fileSzie:Int64 = 0
    
    enum delsuccessType {
    case email
    case other
    }
    
    var type:delsuccessType = .other
    
    override func viewDidLoad() {
        super.viewDidLoad()
        bottomBtn.layer.cornerRadius = 15
        
//        animationView.frame = CGRect(x: (ScreenW-CGFloat(250.RH()))/2 + 20.RW(), y: 70.RH(), width: 250.RH(), height: 250.RH()) // 设置 frame
        view.addSubview(animationView)
        
        animationView.snp.makeConstraints { make in
            make.centerX.equalToSuperview().offset(20.RW())
            make.bottom.equalTo(conTitle.snp.top).offset(15)
            make.size.equalTo(250)
        }
        
        startAnimation()
        reloadUI()
    }
    
    
    lazy var animationView : LottieAnimationView = {
        let animationView = LottieAnimationView(name: "delSuccessCelebrate")
        animationView.loopMode = .playOnce
        return animationView
    }()

    
    func startAnimation() {
        // 播放动画
        animationView.play { [weak self] finished in
            // 动画结束后等待 2 秒再重新播放
            guard let self = self else { return }
            if finished {
                DispatchQueue.main.asyncAfter(deadline: .now() + 2.0) {
                    self.startAnimation() // 重新开始动画
                }
            }
        }
    }

    @IBAction func closeClick(_ sender: Any) {
        vibrate()
        self.dismiss(animated: true) {
            self.closeCall()
        }
    }
    
    
    func reloadUI(){

        let size = fileSzie
        
        points.text = "Save 10 points"
        
        if type == .email {
            bottomText.isHidden = true
            delText.text = "\(fileCount) email\(fileCount > 1 ? "s" : ""  )"
            return
        }else{
            delText.text = "\(fileCount) \(delType)(\(FileTool().formatBytes(size)))"
            bottomText.text = "Clear the \"Recently Deleted\" album on iPhone to free up \(FileTool().formatBytes(size)) of space."
            bottomText.isHidden = false
        }
        
        // 设置 points 标签
        let pointsAttributedString = NSMutableAttributedString(string: "Save 10 points")
        let pointsRange = (points.text! as NSString).range(of: "10 points")
        pointsAttributedString.addAttribute(.foregroundColor, value:UIColor.colorWithHex(hexStr: "#0082FF"), range: pointsRange)
        points.attributedText = pointsAttributedString
              
        // 设置 delText 标签
        let formattedSize = FileTool().formatBytes(size)
        let delTextString = "\(fileCount) \(delType)(\(formattedSize))"
        let delTextAttributedString = NSMutableAttributedString(string: delTextString)

        // 设置  fetchResult.count 和 delType 的范围
        let countRange = (delTextString as NSString).range(of: "\(fileCount)")
        let delTypeRange = (delTextString as NSString).range(of: delType)
              
        // 设置颜色为蓝色
        delTextAttributedString.addAttribute(.foregroundColor, value: UIColor.colorWithHex(hexStr: "#0082FF"), range: countRange)
        delTextAttributedString.addAttribute(.foregroundColor, value: UIColor.colorWithHex(hexStr: "#0082FF"), range: delTypeRange)
              
        // 其他文本设置为灰色
        let otherRange = (delTextString as NSString).range(of: "(\(formattedSize))") // 获取其他文本的范围
        delTextAttributedString.addAttribute(.foregroundColor, value: UIColor.colorWithHex(hexStr: "#1A1A1A"), range: otherRange)
        delText.attributedText = delTextAttributedString
    }

}
