//
//  PMLoadingView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/28.
//

import UIKit
import Lottie

class PMLoadingHUD{
    
    static let share = PMLoadingHUD()
    
    lazy var loadingView:PMLoadingView = {
        let loadingView = PMLoadingView()
        loadingView.frame = CGRect(x: 0, y: 0, width: ScreenW, height: ScreenH)
        return loadingView
    }()
    
    func config(){
        //loadingView.animationView.play()
        loadingView.isHidden = false
    }
    
    func show(_ title:String = "Deleting...",_ subTitle:String = "Please wait on the screen. This might take several minutes."){
        disMiss()
        DispatchQueue.main.async {
            cWindow?.addSubview(self.loadingView)
            cWindow?.bringSubviewToFront(self.loadingView)
            self.loadingView.setTitleAndSubTitle(title: title, subTitle: subTitle)
            self.loadingView.animationView.play()
        }
    }
    
    func showLoding(_ title:String = "Loding...",_ subTitle:String = "Please wait on the screen. This might take several minutes."){
        disMiss()
        DispatchQueue.main.async {
            cWindow?.addSubview(self.loadingView)
            cWindow?.bringSubviewToFront(self.loadingView)
            self.loadingView.setTitleAndSubTitle(title: title, subTitle: subTitle)
           self.loadingView.animationView.play()
        }
    }
    
    
    func disMiss(){
        DispatchQueue.main.async {
            self.loadingView.animationView.stop()
            self.loadingView.removeFromSuperview()
        }
    }
    
    func setTimerDismiss(){
        
    }
}

class PMLoadingView: UIView {
    var title: UILabel!
    var subtitle: UILabel!
    var animationView: LottieAnimationView!
    
    // 标记动画是否已加载
    private var isAnimationLoaded = false
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        self.backgroundColor = UIColor.black.withAlphaComponent(0.8)
        
        // 先创建空的动画视图，不加载内容
        animationView = LottieAnimationView()
        animationView.loopMode = .loop
        addSubview(animationView)
        
        title = UILabel()
        title.text = "Deleting..."
        title.textColor = .white
        title.font = UIFont.systemFont(ofSize: 18, weight: .semibold)
        addSubview(title)
        
        subtitle = UILabel()
        subtitle.text = "Please wait on the screen. This might take several minutes."
        subtitle.textColor = .white
        subtitle.numberOfLines = 0
        subtitle.textAlignment = .center
        subtitle.font = UIFont.systemFont(ofSize: 18, weight: .semibold)
        addSubview(subtitle)
        
        // 设置约束
        setupConstraints()
        
        // 异步加载动画
        loadAnimationAsync()
    }
    
    private func setupConstraints() {
        animationView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
            make.width.equalTo(300)
            make.height.equalTo(300)
        }
        
        title.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(animationView.snp.bottom).offset(-50)
        }
        
        subtitle.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.width.equalTo(250)
            make.top.equalTo(title.snp.bottom).offset(2)
        }
    }
    
    private func loadAnimationAsync() {
        DispatchQueue.global().async { [weak self] in
            guard let self = self else { return }
            
            // 在后台线程解析动画
            let animation = LottieAnimation.named("PMAnimationLoaing")
            
            DispatchQueue.main.async {
                // 主线程更新 UI
                self.animationView.animation = animation
                self.isAnimationLoaded = true
                
                // 如果视图已经显示，则立即播放
                if self.superview != nil {
                    self.animationView.play()
                }
            }
        }
    }
    
    func setTitleAndSubTitle(title: String, subTitle: String) {
        self.title.text = title
        self.subtitle.text = subTitle
    }
    
    // 重写添加到父视图的方法，在视图显示时播放动画
//    override func didMoveToSuperview() {
//        super.didMoveToSuperview()
//        if isAnimationLoaded && superview != nil {
//            animationView.play()
//        }
//    }
}
