//
//  LaunchViewController.swift
//  PhoneManager
//
//  Created by edy on 2025/5/19.
//

import UIKit
import Lottie

class LaunchViewController: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = UIColor.colorWithHex(hexStr: "#0082FF")
        let logoImage = UIImageView()
        logoImage.image = UIImage.init(named: "icon_phone_manager")
        view.addSubview(logoImage)
        
        let nameImage = UIImageView()
        nameImage.image = UIImage.init(named: "icon_phone_manager_name")
        view.addSubview(nameImage)
        
        
        view.addSubview(LaunchingLoop)
        
        logoImage.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(kSafeAreaInsets.top+150)
        }
        
        nameImage.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(logoImage.snp.bottom).offset(12)
        }

        LaunchingLoop.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.width.height.equalTo(150)
            make.bottom.equalToSuperview().offset(-60 * RScreenH())
        }
        
        DispatchQueue.main.asyncAfter(deadline: .now() + 3, execute: {
            self.dismiss(animated: true)
        })
    }
    

    private lazy var LaunchingLoop: LottieAnimationView = {
        let animationView = LottieAnimationView(name: "launch_loaing")
        animationView.loopMode = .loop
        animationView.play()
        return animationView
    }()

}
