//
//  HomeLaunchView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/19.
//

import UIKit
import Lottie

class HomeLaunchView:UIView {
    
    var disMissBlock:(() ->Void)?

    override init(frame: CGRect) {
        super.init(frame: frame)
        self.frame = frame
        configUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func configUI(){
        
       // backgroundColor = UIColor.colorWithHex(hexStr: "#0082FF")
        
        self.az_setGradientBackground(with: [UIColor.colorWithHex(hexStr: "#2AB4FF"),UIColor.colorWithHex(hexStr: "#0082FF")], locations: nil, start: CGPoint(x: 0, y: 0), end: CGPoint(x: 0, y: 1))
        
        
        
        let logoImage = UIImageView()
        logoImage.image = UIImage.init(named: "icon_phone_manager")
        addSubview(logoImage)
        
//        let nameImage = UIImageView()
//        nameImage.image = UIImage.init(named: "icon_phone_manager_name")
//        addSubview(nameImage)
        
        
       // addSubview(LaunchingLoop)
        
        logoImage.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
//            make.top.equalTo(kSafeAreaInsets.top+150)
        }
        
//        nameImage.snp.makeConstraints { make in
//            make.centerX.equalToSuperview()
//            make.top.equalTo(logoImage.snp.bottom).offset(12)
//        }

//        LaunchingLoop.snp.makeConstraints { make in
//            make.centerX.equalToSuperview()
//            make.width.height.equalTo(150)
//            make.bottom.equalToSuperview().offset(-60 * RScreenH())
//        }
    }
    
    
    func show(){
        KEYWINDOW()?.addSubview(self)
        
        DispatchQueue.main.asyncAfter(deadline: .now() + 3, execute: {
            self.alpha = 1
            UIView.animate(withDuration: 0.3) {
                self.alpha = 0
            }completion: { _ in
                self.removeFromSuperview()
            }
            self.disMissBlock?()
        })
    }
    
//    private lazy var LaunchingLoop: LottieAnimationView = {
//        let animationView = LottieAnimationView(name: "launch_loaing")
//        animationView.loopMode = .loop
//        animationView.play()
//        return animationView
//    }()

}
