//
//  LandingCollectionCell.swift
//  PhoneManager
//
//  Created by zxhy on 2025/3/20.
//

import UIKit
import Lottie

class LandingCollectionCell:UICollectionViewCell {
    
    @IBOutlet weak var titleLabel: UILabel!
    
    @IBOutlet weak var tipLabel: UILabel!
    
    private var animationView:LottieAnimationView?
    
    private var backView:UIImageView?
    
    static let identifiers = "LandingCollectionCellID"
    
    var model:LandingCollectionModel? {
        
        didSet {
            
            guard let model else {return}
            
            titleLabel.text = model.title
            
            let fullText = model.tip
            
            // 创建 NSMutableAttributedString
            let attributedString = NSMutableAttributedString(string: fullText)
            
            // 设置 "+80%" 的样式
            let blueColor = UIColor.colorWithHex(hexStr: mColor)
            let largeFont = UIFont.systemFont(ofSize: 28, weight: .bold)
            let range1 = (fullText as NSString).range(of: model.tipKey)
            attributedString.addAttribute(.foregroundColor, value: blueColor, range: range1)
            attributedString.addAttribute(.font, value: largeFont, range: range1)
            
            // 设置其他文本的样式
            let darkGrayColor = UIColor.colorWithHex(hexStr: black3Color)
            let smallFont = UIFont.systemFont(ofSize: 16, weight: .regular)
            let range2 = NSRange(location: range1.length, length: fullText.count - range1.length)
            attributedString.addAttribute(.foregroundColor, value: darkGrayColor, range: range2)
            attributedString.addAttribute(.font, value: smallFont, range: range2)
            
            backView?.removeFromSuperview()
            
            if (model.animation == "removeDuplicatesLight") {
                
                backView = UIImageView(image: UIImage(named: "img_guide_02"))
                contentView.addSubview(backView ?? UIView())
            }
            
            // 将 NSAttributedString 赋值给 UILabel
            tipLabel.attributedText = attributedString
            tipLabel.numberOfLines = 2 // 支持多行
            
            animationView?.removeFromSuperview()
            
            animationView = LottieAnimationView(name: model.animation)
            
            animationView?.loopMode = .playOnce
            
            contentView.addSubview(animationView ?? UIView())
            
            playAnimation()
            
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
    }
    
    func playAnimation() {
        
        animationView?.play()
    }
    
    override func layoutSubviews() {
        
        super.layoutSubviews()
        
        if (model?.animation == "increaseSpaceLight" || model?.animation == "maximizeYourTimeLight") {
            
            animationView?.size = CGSizeMake(258, 258 / 0.9109)
        }else if (model?.animation == "removeDuplicatesLight") {
            
            animationView?.size = CGSizeMake(258, 258 / 1.494)
        }
        
        animationView?.centerY = (tipLabel.y + tipLabel.height) + (contentView.height - (tipLabel.y + tipLabel.height)) / 2
        animationView?.centerX = (contentView.width) / 2
        
        backView?.size = CGSizeMake(286, 288)
        backView?.center = animationView?.center ?? CGPointZero
    }
    
}


