//
//  NewGuideOneCell.swift
//  PhoneManager
//
//  Created by edy on 2025/4/28.
//

import UIKit
import Lottie

class NewGuideOneCell: UICollectionViewCell {

    @IBOutlet weak var subtitle: UILabel!
    @IBOutlet weak var htitle: UILabel!
    
    @IBOutlet weak var userL: UILabel!
    override func awakeFromNib() {
        super.awakeFromNib()
        
        setSubtitleAttr()
        sethtitleAttr()
        
        addSubview(animationView)
        animationView.snp.makeConstraints { make in
            make.width.equalTo(375.RW())
            make.height.equalTo(255.RW())
            make.right.equalToSuperview()
            make.top.equalTo(userL.snp.bottom).offset(35)
        }
        
        animationView.play()
        
    }
    
    lazy var animationView : LottieAnimationView = {
        let animationView = LottieAnimationView(name: "animation_guide_0")
        animationView.loopMode = .loop
        return animationView
    }()
    
    func setSubtitleAttr(){
        // 创建富文本
        let fullText = "Over 1000+ users worldwide"
               
        // 创建可变的富文本字符串
        let attributedString = NSMutableAttributedString(string: fullText)
               
        // 定义 "1000+" 的范围
        let range = (fullText as NSString).range(of: "1000+")
               
        // 设置其他部分的属性（字体颜色为黑色，Regular 字体）
        attributedString.addAttribute(.foregroundColor, value: UIColor.colorWithHex(hexStr: "#151515"), range: NSRange(location: 0, length: fullText.count))
        attributedString.addAttribute(.font, value: UIFont.systemFont(ofSize: 24), range: NSRange(location: 0, length: fullText.count))

        // 设置 "1000+" 的属性（字体颜色为蓝色，字体加粗）
        attributedString.addAttribute(.foregroundColor, value: UIColor.colorWithHex(hexStr: "#0183FF"), range: range)
        attributedString.addAttribute(.font, value: UIFont.boldSystemFont(ofSize: 24), range: range)

               // 将属性字符串设置为 UILabel 的文本
        subtitle.attributedText = attributedString
        
    }
    
    func sethtitleAttr(){
        // 创建富文本
        let fullText = "Selected 'Phone manager'"
               
        // 创建可变的富文本字符串
        let attributedString = NSMutableAttributedString(string: fullText)
               
        let range = (fullText as NSString).range(of: "'Phone manager'")
               

        attributedString.addAttribute(.foregroundColor, value: UIColor.colorWithHex(hexStr: "#262626"), range: NSRange(location: 0, length: fullText.count))
       
       
        attributedString.addAttribute(.foregroundColor, value: UIColor.colorWithHex(hexStr: "#0183FF"), range: range)
       
               // 将属性字符串设置为 UILabel 的文本
        htitle.attributedText = attributedString
        
    }

}
