//
//  MaintaiDetialVideoCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/14.
//

import UIKit
import AVKit

class MaintaiDetialVideoCell: UITableViewCell {
    
    
    var selectBtn:UIButton!
    var selectChangeBlock:(() ->Void)?
    
    var playerLayer:AVPlayerLayer!

    
    override func awakeFromNib() {
        super.awakeFromNib()
        setupPlayer()
        setUI()
    }
    
    private func setUI(){
        
        selectBtn = UIButton()
        selectBtn.setImage(UIImage.init(named: "icon_maintai_unselect_big"), for: .normal)
        selectBtn.setImage(UIImage.init(named: "icon_maintai_select_big"), for: .selected)
        contentView.addSubview(selectBtn)
        contentView.bringSubviewToFront(selectBtn)
        selectBtn.addTarget(self, action: #selector(selectChange), for: .touchUpInside)
        selectBtn.snp.makeConstraints { make in
            make.right.equalTo(-22)
            make.bottom.equalTo(0)
            make.size.equalTo(34)
        }
    }
    
    private func setupPlayer() {
        playerLayer = AVPlayerLayer.init(player: videoPlayer)
        playerLayer.backgroundColor = UIColor.black.cgColor
        contentView.layer.addSublayer(playerLayer)
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        // 设置播放器层的frame
        playerLayer.frame = CGRect(x: 22, y: 10, width: contentView.width-44, height: contentView.height-10)
        playerLayer.cornerRadius = 15
        playerLayer.masksToBounds = true
    }
    
    var model:AssetModel?{
        didSet{
            guard let model = model else{
                return
            }
            
            PhotoManager.shared.getVideoURL(localIdentifier: model.localIdentifier, completion: {[weak self] url in
                guard let weakSelf = self else { return }
                weakSelf.configure(with: url)
            })
        }
    }
    
    lazy var videoPlayer:AVPlayer = {
        let palyer = AVPlayer.init()
        palyer.volume = 0
        palyer.isMuted = true
        return palyer
    }()
    
    
    
    func configure(with videoURL: URL?) {

        
        guard let videoURL = videoURL else{
            videoPlayer.pause()
            return
        }
        Print("视频url",videoURL)
        
        let item = AVPlayerItem.init(url: videoURL)
        videoPlayer.replaceCurrentItem(with: item)
        videoPlayer.play()

        NotificationCenter.default.addObserver(self,
                                             selector: #selector(playerDidFinishPlaying),
                                             name: .AVPlayerItemDidPlayToEndTime,
                                             object: item)
    }

    @objc private func playerDidFinishPlaying() {
        videoPlayer.seek(to: .zero)
        videoPlayer.play()
    }
    
    @objc func selectChange(){
        selectChangeBlock?()
    }

    deinit{
        print("释放",self)
        // 停止播放
        videoPlayer.pause()
        videoPlayer.replaceCurrentItem(with: nil)
        // 移除观察者
        NotificationCenter.default.removeObserver(self)
    }
}
