//
//  HomeVideoDetailCell.swift
//  PhoneManager
//
//  Created by edy on 2025/4/9.
//

import Foundation
import Photos

class HomeVideoDetailCell : UICollectionViewCell {

    var clickCallBack : (Bool,Int)->Void = {choose,order in}
    
    var cellCallBack : (AssetModel,Int)->Void = {ident,order in}
    
    var currentMediaType : Int = 0
    
    var resourceIdent : AssetModel?  {
        didSet{
            
            guard let model = resourceIdent else{
                return
            }
            
            self.backImageView.asset.load(withLocalIdentifier: model.localIdentifier,placeholder: UIImage.init(named: "videosmoren"))
            
            let sizeKB : Double = Double(model.assetSize / 1000)
            if sizeKB < 1000{
                self.saveSizeLabel.text = String(format: "%.2fKB" ,sizeKB)
            }else if sizeKB < (1000 * 1000) && sizeKB > 1000{
                self.saveSizeLabel.text = String(format: "%.2fMB" ,sizeKB/1000)
            }else{
                self.saveSizeLabel.text = String(format: "%.2fGB" ,sizeKB/(1000 * 1000))
            }
            
            
//            // 定义请求选项来获取视频的第一帧
//            let options = PHImageRequestOptions()
//            // 获取当前版本的照片或视频
//            options.version = .current
//            // 尽可能快地提供结果
//            options.deliveryMode = .opportunistic
//            // 允许从iCloud请求
//            options.isNetworkAccessAllowed = true
//            // 异步请求
//            options.isSynchronous = false
            // 从 PHAsset 获取 AVAsset
//            if let videoAsset = PhotoAndVideoMananger.mananger.getPHAsssetwithID(ids: [resourceIdent!.localIdentifier]){
//                // 使用requestImageForAsset方法请求视频的第一帧图片
//                PHImageManager.default().requestImage(for: videoAsset, targetSize: CGSize(width: 400, height: 400), contentMode: PHImageContentMode.aspectFit, options: options) { image, _ in
//                    // 处理获取到的图片
//                    if let thumbnailImage = image {
//                        
//                        // 图片大小
//                        let resources = PHAssetResource.assetResources(for: videoAsset)
//                        var assetSize : Int = 0
//                        for resource in resources {
//                            if let fileSize = resource.value(forKey: "fileSize") as? Int64 {
//                                assetSize += Int(fileSize)
//                            }
//                        }
//                        DispatchQueue.main.async {
//                            // 确保在主线程更新UI
//                            self.backImageView.image = thumbnailImage
//                            let sizeKB : Double = Double(assetSize / 1000)
//                            if sizeKB < 1000{
//                                self.saveSizeLabel.text = String(format: "%.2f KB" ,sizeKB)
//                            }else if sizeKB < (1000 * 1000) && sizeKB > 1000{
//                                self.saveSizeLabel.text = String(format: "%.2f MB" ,sizeKB/1000)
//                            }else{
//                                self.saveSizeLabel.text = String(format: "%.2f GB" ,sizeKB/(1000 * 1000))
//                            }
//                        }
//                    } else {
//                        print("无法获取图片")
//                    }
//                }
//            }
        }
    }
    
    var currentOrder : Int = 0
    
    var choose : Bool = false {
        didSet{
            if choose {
                self.selectImageView.image = UIImage(named: "重复项说明-icon-选中")
            }else{
                self.selectImageView.image = UIImage(named: "Frame 6")
            }
        }
    }
    
    
    lazy var backImageView: UIImageView = {
        let view = UIImageView()
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        view.layer.masksToBounds = true
        view.layer.cornerRadius = 12
        
        view.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(cellClick))
        view.addGestureRecognizer(tap)
        
        return view
    }()
    
    lazy var extensionView: UIView = {
        let view = UIView()
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(selectClick))
        view.addGestureRecognizer(tap)
        return view
    }()
    
    lazy var playImageView: UIImageView = {
        let view = UIImageView()
        view.backgroundColor = .clear
        view.image = UIImage(named: "Frame 5")
        view.isUserInteractionEnabled = true
        return view
    }()
    
    
    
    lazy var saveSizeView: UIView = {
        let view = UIView()
        view.layer.masksToBounds = true
        view.layer.cornerRadius = 12
        view.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        return view
    }()
    
    lazy var saveSizeLabel: UILabel = {
        let view = UILabel()
        view.textAlignment = .left
        view.textColor = UIColor(red: 1, green: 1, blue: 1, alpha: 1)
        view.font = UIFont.systemFont(ofSize: 12, weight: .semibold)
        view.text = "0.0MB"
        return view
    }()
    
    lazy var moreImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "Frame 9")
        view.backgroundColor = .clear
        return view
    }()
    
    lazy var selectImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "Frame 6")
        view.backgroundColor = .clear
        view.isUserInteractionEnabled = true
        
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(selectClick))
        view.addGestureRecognizer(tap)
        
        return view
    }()
    
    
    @objc func selectClick(){
        self.choose = !self.choose
        clickCallBack(self.choose,self.currentOrder)
    }
    
    @objc func cellClick(){
        cellCallBack(self.resourceIdent!,self.currentOrder)
    }
    
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        self.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(imageClick))
        self.addGestureRecognizer(tap)
        
        self.addSubview(self.backImageView)
        self.backImageView.addSubview(self.playImageView)
        self.addSubview(self.saveSizeView)
        self.saveSizeView.addSubview(self.saveSizeLabel)
        self.saveSizeView.addSubview(self.moreImageView)
        self.addSubview(self.selectImageView)
        self.addSubview(self.extensionView)
        
        self.backImageView.snp.makeConstraints { make in
            make.left.right.height.width.equalToSuperview()
        }
        self.playImageView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.height.equalTo(26.RW())
        }
        self.saveSizeView.snp.makeConstraints { make in
            make.left.top.equalToSuperview().offset(6)
            make.height.equalTo(24)
        }
        self.saveSizeLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(11)
            make.centerY.equalToSuperview()
            make.height.equalTo(17)
        }
        
        self.moreImageView.snp.makeConstraints { make in
            make.left.equalTo(saveSizeLabel.snp.right).offset(4)
            make.centerY.equalToSuperview()
            make.height.width.equalTo(16)
            make.right.equalToSuperview().offset(-11)
        }
        
        self.selectImageView.snp.makeConstraints { make in
            make.bottom.right.equalToSuperview().offset(-6)
            make.height.width.equalTo(18)
        }
        self.extensionView.snp.makeConstraints { make in
            make.center.equalTo(self.selectImageView.snp.center)
            make.height.width.equalTo(80)
        }
        
       
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    @objc func imageClick(){
      
    }
    
}
