//
//  HomePhotosDetailCollectionCell.swift
//  PhoneManager
//
//  Created by edy on 2025/4/9.
//

import Foundation
import Photos

class HomePhotosDetailCollectionCell : UICollectionViewCell {
    
    var clickCallBack : (Bool,Int)->Void = {choose,order in}
    
    var cellCallBack : (AssetModel,Int)->Void = {ident,order in}
    
    var currentMediaType : Int = 0
    
    
    var choose : Bool = false {
        didSet{
            if choose {
                self.selectImageView.image = UIImage(named: "重复项说明-icon-选中")
            }else{
                self.selectImageView.image = UIImage(named: "Frame 6")
            }
        }
    }
    
    var resourceIdent : AssetModel? {
        didSet {
            let sizeKB : Double = Double((resourceIdent?.assetSize ?? 0) / 1000)
            if sizeKB < 1000{
                self.saveSizeLabel.text = String(format: "%.2fKB" ,sizeKB)
            }else if sizeKB < (1000 * 1000) && sizeKB > 1000{
                self.saveSizeLabel.text = String(format: "%.2fMB" ,sizeKB/1000)
            }else{
                self.saveSizeLabel.text = String(format: "%.2fGB" ,sizeKB/(1000 * 1000))
            }
        }
    }
    
    var currentOrder : Int = 0
    
    
    lazy var saveSizeView: UIView = {
        let view = UIView()
        view.layer.masksToBounds = true
        view.layer.cornerRadius = 12
        view.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        return view
    }()
    
    lazy var saveSizeLabel: UILabel = {
        let view = UILabel()
        view.textAlignment = .left
        view.textColor = UIColor(red: 1, green: 1, blue: 1, alpha: 1)
        view.font = UIFont.systemFont(ofSize: 12, weight: .semibold)
        view.text = "0.0MB"
        return view
    }()
    
    lazy var moreImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "Frame 9")
        view.backgroundColor = .clear
        return view
    }()
        
    lazy var backImageView: UIImageView = {
        let view = UIImageView()
        view.clipsToBounds = true
        view.layer.masksToBounds = true
        view.layer.cornerRadius = 12
        view.backgroundColor = .gray
        view.contentMode = .scaleAspectFill
        
        view.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(cellClick))
        view.addGestureRecognizer(tap)
        
        return view
    }()
    
    lazy var extensionView: UIView = {
        let view = UIView()
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(selectClick))
        view.addGestureRecognizer(tap)
        return view
    }()
    
    lazy var selectImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "ic_sel_com")
        view.backgroundColor = .clear
        view.isUserInteractionEnabled = true
        
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(selectClick))
        view.addGestureRecognizer(tap)
        
        return view
    }()
    
    
    
    @objc func cellClick(){
        cellCallBack(self.resourceIdent!,self.currentOrder)
    }
    
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        self.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(imageClick))
        self.addGestureRecognizer(tap)
        
        self.addSubview(self.backImageView)
        self.addSubview(self.selectImageView)
        self.addSubview(self.extensionView)
        
        self.addSubview(self.saveSizeView)
        self.saveSizeView.addSubview(self.saveSizeLabel)
        self.saveSizeView.addSubview(self.moreImageView)
        
        
        self.backImageView.snp.makeConstraints { make in
            make.left.right.height.width.equalToSuperview()
        }
        
        self.extensionView.snp.makeConstraints { make in
            make.center.equalTo(self.selectImageView.snp.center)
            make.height.width.equalTo(80)
        }
        
        self.selectImageView.snp.makeConstraints { make in
            make.bottom.right.equalToSuperview().offset(-6)
            make.height.width.equalTo(18.38)
        }
        
        self.saveSizeView.snp.makeConstraints { make in
            make.left.top.equalToSuperview().offset(6)
            make.height.equalTo(24)
        }
        self.saveSizeLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(11)
            make.centerY.equalToSuperview()
            make.height.equalTo(17)
        }
        
        self.moreImageView.snp.makeConstraints { make in
            make.left.equalTo(saveSizeLabel.snp.right).offset(4)
            make.centerY.equalToSuperview()
            make.height.width.equalTo(16)
            make.right.equalToSuperview().offset(-11)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    @objc func imageClick(){
        
    }
    
    @objc func selectClick(){
        self.choose = !self.choose
        clickCallBack(self.choose,self.currentOrder)
    }
}
