//
//  VideoDetaiNavView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/9.
//

import Foundation

class VideoDetaiNavView : UIView {
    
    var selectAllCallBack : (Bool)->Void = {choose in}
    
    private var backButton:UIButton!
    
    var startSelectCallBack : (Bool)->Void = {choose in}
    
    
    lazy var startSelectButton:UIButton = {
        let button :UIButton = UIButton()
        button.setTitle("Select", for: .normal)
        button.setTitle("Cancel", for: .selected)
        button.setTitleColor(UIColor(red: 0, green: 0.51, blue: 1, alpha: 1), for: .normal)
        button.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.98, alpha: 1)
        button.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .semibold)
        button.layer.cornerRadius = 12
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(startSelectButtonAction), for: .touchUpInside)
        return button
    }()
    
    lazy var seletedAllBtn:SelectAllButton = {
        
        let view = SelectAllButton()
        view.clipsToBounds = true
        view.layer.cornerRadius = 16
        view.tapCallback = {[weak self] isselect in
            self?.seletedAllBtnClick()
        }
        return view
        
//        let btn:UIButton = UIButton(frame: CGRect(x: 0, y: 0, width: 115, height: 32))
//        btn.isSelected = false
//        btn.backgroundColor = UIColor.colorWithHex(hexStr: "#F2F6FC")
//        btn.setImage(UIImage.init(named: "ic_check_similar"), for: .normal)
//        btn.setTitle("Select All", for: .normal)
//        btn.setImage(UIImage.init(named: "ic_close_similar"), for: .selected)
//        btn.setTitle("Unselect all", for: .selected)
//        btn.setTitleColor(UIColor.colorWithHex(hexStr: mColor), for: .normal)
//        btn.setTitleColor(UIColor.colorWithHex(hexStr: black3Color), for: .selected)
//        btn.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .bold)
//        btn.changBtnWithStytl(btnStyle: .defalut, margin: 8)
//        btn.addTarget(self, action: #selector(seletedAllBtnClick), for: .touchUpInside)
//        btn.layer.cornerRadius = btn.height / 2
//        return btn
    }()
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        
        backgroundColor = .white

        backButton = UIButton()
        backButton.setImage(UIImage(named: "nav_back"), for: .normal)
        backButton.addTarget(self, action: #selector(backBtnClick), for: .touchUpInside)
        self.addSubview(backButton)
        
        self.addSubview(self.seletedAllBtn)

//        seletedAllBtn.x = marginLR
//        seletedAllBtn.centerY = navCenterY
        
        seletedAllBtn.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(marginLR)
            make.height.equalTo(32)
            make.centerY.equalTo(navCenterY)
        }
        
        
        backButton.snp.makeConstraints { make in
            make.centerY.equalTo(navCenterY)
            make.left.equalToSuperview().offset(marginLR)
            make.width.height.equalTo(iconWH)
        }
        self.addSubview(self.startSelectButton)
        self.startSelectButton.snp.makeConstraints { make in
            make.centerY.equalTo(self.backButton.snp.centerY)
            make.right.equalToSuperview().offset(-marginLR)
            make.width.equalTo(91)
            make.height.equalTo(24)
        }
        
        self.seletedAllBtn.isHidden = true
        
    }
    
    @objc private func backBtnClick() {
        self.responderViewController()?.navigationController?.popViewController(animated: true)
    }
    
    @objc func seletedAllBtnClick() {
        
        DispatchQueue.main.async {[weak self] in
            guard let self  else {return}
//            seletedAllBtn.isSelected = !seletedAllBtn.isSelected
//            self.seletedAllBtn.width = seletedAllBtn.isSelected ? 131 : 115
//            seletedAllBtn.x = marginLR
            self.selectAllCallBack(seletedAllBtn.isSelected)
        }
        
    }
    
    @objc func startSelectButtonAction(){
        self.startSelectButton.isSelected = !self.startSelectButton.isSelected
        self.seletedAllBtn.isHidden = !self.startSelectButton.isSelected
        if !self.startSelectButton.isSelected {
            seletedAllBtn.isSelected = false
            seletedAllBtnClick()
        }
        backButton.isHidden = self.startSelectButton.isSelected
        self.startSelectCallBack(self.startSelectButton.isSelected)
    }
}
