//
//  AnchorRotatableView.swift
//  AIClean
//
//  Created by 赵前 on 2025/5/10.
//

import Foundation
import UIKit

class PhotosRemoveBaseView: UIView {
    
    var currentIndex : Int?
    
    var initialCenter: CGPoint = .zero
    
    var url : URL?
    
    var innerVideoController : VideoViewController?
    
    func reload(index:Int) -> Void {
        if let url = url {
            if self.innerVideoController == nil {
                self.innerVideoController = VideoViewController()
                if let vc = self.innerVideoController {
                    vc.isAutoPlay = index == 0
                    vc.url = url
                    self.imageView.removeFromSuperview()

                    self.responderViewController()?.addChild(vc)

                    self.addSubview(vc.view)
                    vc.view.snp.makeConstraints { make in
                        make.left.top.bottom.right.equalToSuperview()
                    }
                    vc.setupPlayer()
                    vc.didMove(toParent: self.responderViewController())
                }
            }else {
                self.innerVideoController?.playerViewController.player?.play()
                self.innerVideoController?.player?.isMuted = true
                self.innerVideoController?.player?.volume = 0
            }
        }
    }
    
    var mediaType : TrashTypeEnum?
    
    lazy var maskTempleteView : UIView = {
        let view = UIView(frame: CGRectMake(0, 0, self.width, self.height))
        return view
    }()
    
    
    private let imageView = UIImageView()
    private let leftButton = UIButton()
    private let rightButton = UIButton()
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.layer.cornerRadius = 20
        self.clipsToBounds = true
        setupUI()
        
        self.imageView.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(showDeatail))
        imageView.backgroundColor = .white
        self.imageView.addGestureRecognizer(tap)
    }
    
    
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        // 配置图片视图
        imageView.contentMode = .scaleAspectFit
        addSubview(imageView)

        leftButton.frame = CGRect(x: 0, y: 0, width: 95, height: 42)
        if self.url != nil {
            self.leftButton.center = self.innerVideoController?.view.center ?? imageView.center
        }else {
            self.leftButton.center = imageView.center
        }
        leftButton.setTitle("Delete", for: .normal)
        leftButton.backgroundColor = UIColor(red: 0.95, green: 0.21, blue: 0.21, alpha: 1)
        leftButton.tintColor = .white
        leftButton.layer.cornerRadius = 21
        leftButton.clipsToBounds = true
        leftButton.alpha = 0
        addSubview(leftButton)
        
        
        rightButton.frame = CGRect(x: 0, y: 0, width: 95, height: 42)
        if self.url != nil {
            self.rightButton.center = self.innerVideoController?.view.center ?? imageView.center
        }else {
            self.rightButton.center = imageView.center
        }
        rightButton.setTitle("Retain", for: .normal)
        rightButton.backgroundColor = UIColor(red: 0.18, green: 0.76, blue: 0.35, alpha: 1)
        rightButton.tintColor = .white
        rightButton.layer.cornerRadius = 21
        rightButton.clipsToBounds = true
        rightButton.alpha = 0
        addSubview(rightButton)
        
        
    }
    
    func configure(with image: UIImage) {
        imageView.image = image
        imageView.frame = bounds
    }
    
    func showLeftButton() {
        if self.url != nil {
            self.leftButton.center = self.innerVideoController?.view.center ?? imageView.center
        }else {
            self.leftButton.center = imageView.center
        }
        self.leftButton.alpha = 1
        self.rightButton.alpha = 0
        self.maskTempleteView.backgroundColor = UIColor(red: 0.95, green: 0.21, blue: 0.21, alpha: 0.4000)
        self.addSubview(self.maskTempleteView)
        self.bringSubviewToFront(self.leftButton)
    }
    
    func showRightButton() {
        if self.url != nil {
            self.rightButton.center = self.innerVideoController?.view.center ?? imageView.center
        }else {
            self.rightButton.center = imageView.center
        }
        self.bringSubviewToFront(self.rightButton)
        UIView.animate(withDuration: 0.2) {
            self.rightButton.alpha = 1
            self.maskTempleteView.backgroundColor = UIColor(red: 0.26, green: 0.78, blue: 0.41, alpha: 0.4000)
            self.addSubview(self.maskTempleteView)
            self.leftButton.alpha = 0
        }
    }
    
    func hideButtons() {
       
        UIView.animate(withDuration: 0.2) { [self] in
            self.leftButton.alpha = 0
            self.rightButton.alpha = 0
            self.maskTempleteView.removeFromSuperview()
            if self.url != nil {
                self.rightButton.center = self.innerVideoController?.view.center ?? imageView.center
                self.leftButton.center = self.innerVideoController?.view.center ?? imageView.center
            }else {
                self.leftButton.center = self.imageView.center
                self.rightButton.center = self.imageView.center
            }
        }
    }
    
    @objc func showDeatail(){
        let vc : PhotoDetailViewController = PhotoDetailViewController()
        vc.showView.icon = self.imageView.image
        vc.modalPresentationStyle = .fullScreen
        self.responderViewController()?.present(vc, animated: true)
        
    }
}
