//
//  HomeVideoDetailCustomHeaderView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/9.
//

import Foundation
class HomeVideoDetailCustomHeaderView : UICollectionReusableView {
    
    var filterBoxModel : ResourceFilterBoxModel?
    
    var sortViewSubmitCallBack : (ResourceFilterBoxModel)->Void = {model in}
    
    lazy var modelTitlelabel :UILabel = {
        let label = UILabel()
        label.text = "Videos"
        label.textAlignment = .left
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        return label
    }()
    // 筛选按钮
    lazy var filterButton :  UIButton =  {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "Frame 1"), for: .normal)
        button.setTitle("latest", for: .normal)
        button.layer.cornerRadius = 14
        button.clipsToBounds = true
        button.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 0.1000)
        button.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .semibold)
        button.setTitleColor(UIColor(red: 0.07, green: 0.07, blue: 0.07, alpha: 1), for: .normal)
        button.titleEdgeInsets = UIEdgeInsets(top: 0, left: 5, bottom: 0, right: 0)
        button.addTarget(self, action: #selector(filterButtonAction), for: .touchUpInside)
        button.isHidden = false
        return button
    }()
    lazy var sizeLabel :UILabel = {
        let label = UILabel()
        label.textAlignment = .left
        label.textColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        label.attributedText = self.getAttrText(fullText: "0 Videos")
        return label
    }()
    
    
    func getAttrText(fullText:String)->NSMutableAttributedString{
        let attributedString = NSMutableAttributedString(string: fullText)
        let range = (fullText as NSString).range(of: "Videos")
        attributedString.addAttribute(.foregroundColor, value: UIColor(red: 0.6, green: 0.6, blue: 0.6,alpha:1), range: range)
        return attributedString
       
    }
    
    
    private func setUI(){
        
        self.addSubview(self.modelTitlelabel)
        self.addSubview(self.filterButton)
        self.addSubview(self.sizeLabel)
        
        
        self.modelTitlelabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(0)
            make.top.equalToSuperview().offset(14)
            make.width.equalTo(96 * RScreenW())
            make.height.equalTo(28)
        }
        
        
        
        self.sizeLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(self.filterButton.snp.bottom).offset(8)
            make.height.equalTo(20)
        }
        
       
        self.filterButton.snp.makeConstraints { make in
            make.centerY.equalTo(self.modelTitlelabel.snp.centerY)
            make.right.equalToSuperview().offset(0)
            make.height.equalTo(28)
            make.width.equalTo(98)
        }
    
        addSubview(compressionTipView)
        
        compressionTipView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(80)
            make.top.equalTo(sizeLabel.snp.bottom).offset(10)
        }
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(compressClick))
        compressionTipView.addGestureRecognizer(tap)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.backgroundColor = .white
        setUI()
        
    }
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
        setUI()
    }
    
    @objc func filterButtonAction(){
        if let cWindow = cWindow {
            let filterView : ResourceFilterBoxView = ResourceFilterBoxView.init(frame: cWindow.bounds,startDate: self.filterBoxModel?.startDate,endDate: self.filterBoxModel?.endDate,sortType: self.filterBoxModel?.sortType)
            // 添加毛玻璃效果
            cWindow.showBlur()
            
            cWindow.addSubview(filterView)
            filterView.submitCallBack = {model in
                self.filterBoxModel = model
                DispatchQueue.main.async {
                    self.filterButton.setTitle(model.sortType.rawValue, for: .normal)
                }
                self.sortViewSubmitCallBack(model)
            }
        }
    }
    
    lazy var compressionTipView:VideocompressionHeadView = {
        let compressionTipView = Bundle.main.loadNibNamed("VideocompressionHeadView", owner: nil)?.last as! VideocompressionHeadView
        return compressionTipView
    }()
    
    @objc func compressClick(){
        let vc = CompressController()
        GETCURRENTNAV()?.pushViewController(vc, animated: true)
    }
    
}
