//
//  HomeNavView.swift
//  PhoneManager
//
//  Created by edy on 2025/3/21.
//

import UIKit

class HomeNavView:UIView {
    
//    private var settingBtn:UIButton!
    private var proBtn:UIButton!
    private lazy var homeTitle : UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.text = "Phone Manager"
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        return label
    }()
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        
        backgroundColor = .clear
        
        // 标题
        self.addSubview(self.homeTitle)
        self.homeTitle.snp.makeConstraints { make in
            make.left.equalTo(15 + 8)
            make.top.equalTo(8)
            make.height.equalTo(28)
            make.width.equalTo(149)
        }
        
        // 设置按钮
//        self.settingBtn = UIButton()
//        self.settingBtn.setImage(UIImage(named: "ic_setting_com"), for: .normal)
//        self.settingBtn.addTarget(self, action: #selector(settingBtnClick), for: .touchUpInside)
//        self.addSubview(settingBtn)
//        self.settingBtn.snp.makeConstraints { make in
//            make.centerY.equalTo(self.homeTitle.snp.centerY)
//            make.right.equalTo(-marginLR)
//            make.width.height.equalTo(iconWH)
//            
//        }
        // 会员按钮
        self.proBtn = UIButton(frame: CGRect(x: 0, y: 0, width: 70, height: iconWH))
        self.proBtn.setBackgroundImage(UIImage(named: "ic_pro_home"), for: .normal)
        self.proBtn.addTarget(self, action: #selector(proBtnClick), for: .touchUpInside)
        self.addSubview(proBtn)
        self.proBtn.snp.makeConstraints { make in
            make.centerY.equalTo(self.homeTitle.snp.centerY)
            make.right.equalTo(self.snp.right).offset(-8-iconWH-marginLR)
            make.width.equalTo(78)
            make.height.equalTo(iconWH)
        }
    }
    
}

extension HomeNavView {
    
//    @objc private func settingBtnClick() {
//        let homeNavViewModel = HomeNavViewModel()
//        let settingViewController = SettingViewController()
//        homeNavViewModel.pushToDetailController(currentView: self, destnationController: settingViewController)
//    }
    
    @objc private func proBtnClick() {
        if IAPManager.share.isSubscribed == false {
            HomePayViewController.show {}
        }else {
            let vc : PayCompletedViewController =  PayCompletedViewController()
            vc.modalPresentationStyle = .fullScreen
            self.responderViewController()?.present(vc, animated: true)
        }
    }
}
