//
//  EmptyTrashView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/9.
//

import Foundation

class EmptyTrashView : UIView {
    
    lazy var numberLabel : UILabel = {
        let label = UILabel()
        label.font = UIFont.systemFont(ofSize: 18, weight: .bold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .left
        label.text = "0 images"
        return label
    }()
    lazy var numberTailLabel : UILabel = {
        let label = UILabel()
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        label.textColor = UIColor(red: 0.7, green: 0.7, blue: 0.7, alpha: 1)
        label.textAlignment = .left
        label.text = "in the trash"
        return label
    }()
    
    lazy var infoView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        view.clipsToBounds = true
        view.layer.cornerRadius = 24
        return view
    }()
    lazy var trashImageView: UIImageView = {
        let view = UIImageView()
        view.backgroundColor = .clear
        view.image = UIImage(named: "ic_delete_duplicates")
        return view
    }()
    lazy var trashLabel : UILabel = {
        let label = UILabel()
        label.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        label.textColor = .white
        label.textAlignment = .left
        label.text = "Empty Trash"
        return label
    }()
    
    
    
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(self.numberLabel)
        self.addSubview(self.numberTailLabel)
        self.addSubview(self.infoView)
        self.infoView.addSubview(self.trashImageView)
        self.infoView.addSubview(self.trashLabel)
        
        self.numberLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.top.equalToSuperview().offset(17)
            make.width.equalTo(120)
            make.height.equalTo(25)
        }
        self.numberTailLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.top.equalTo(self.numberLabel.snp.bottom).offset(2)
            make.width.equalTo(150)
            make.height.equalTo(20)
        }
        self.infoView.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-15)
            make.centerY.equalToSuperview()
            make.width.equalTo(180)
            make.height.equalTo(48)
        }
        self.trashImageView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.centerY.equalToSuperview()
            make.width.equalTo(24)
            make.height.equalTo(24)
        }
        self.trashLabel.snp.makeConstraints { make in
            make.left.equalTo(self.trashImageView.snp.right).offset(8)
            make.right.equalToSuperview().offset(-16)
            make.centerY.equalToSuperview()
            make.height.equalTo(22)
        }
        
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
