//
//  DateSelectButtonView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/12.
//

import Foundation

class DateSelectButtonView : UIView {
    
    var closeCallBack : ()->Void = {}
    
    var type : PickerDateType?
    
    lazy var dateButton : UIButton = {
        let button = UIButton(type: .custom)
        button.setTitle("Start date", for: .normal)
        button.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .semibold)
        button.setTitleColor(UIColor(red: 0.07, green: 0.07, blue: 0.07, alpha: 1), for: .normal)
        button.backgroundColor = UIColor(red: 0.9, green: 0.9, blue: 0.9, alpha: 1)
        button.layer.borderColor = UIColor(red: 0.96, green: 0.96, blue: 0.96, alpha: 1).cgColor
        button.layer.borderWidth = 1.0
        button.layer.cornerRadius = 21
        button.clipsToBounds = true
        return button
    }()
    
    lazy var closeButton : UIButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "ic_close_charging"), for: .normal)
        button.addTarget(self, action: #selector(closeButtonAction), for: .touchUpInside)
        return button
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(dateButton)
        
        self.addSubview(closeButton)
        
        self.dateButton.snp.makeConstraints { make in
            make.left.bottom.right.equalToSuperview()
            make.top.equalToSuperview().offset(4)
        }
        self.closeButton.snp.makeConstraints { make in
            make.width.height.equalTo(16)
            make.top.equalToSuperview()
            make.right.equalToSuperview().offset(-5)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func closeButtonAction(){
        reSetButtonTitle()
        self.closeCallBack()
    }
    
    func reSetButtonTitle() {
        DispatchQueue.main.async {
            let title = self.type == .start ? "Start date" : "Over date"
            self.dateButton.setTitle(title, for: .normal)
            self.closeButton.isHidden = true
        }
    }
    
}
