//
//  HomeTabbarItem.swift
//  PhoneManager
//
//  Created by edy on 2025/3/21.
//

import Foundation

func loadTabbarImtesSONFromBundle() -> [HomeTabbarItem]? {
    // 获取 JSON 文件路径
    guard let path = Bundle.main.path(forResource: "TabbarImtesData", ofType: "json") else {
        print("未找到 JSON 文件")
        return nil
    }
    
    do {
        // 读取文件内容
        let data = try Data(contentsOf: URL(fileURLWithPath: path))
        
        // 解析 JSON 数据
        let decoder = JSONDecoder()
        let items = try decoder.decode([HomeTabbarItem].self, from: data)
        return items
    } catch {
        print("解析 JSON 失败：\(error)")
        return nil
    }
}

enum HomeTabbarItemState : String {
    case Charging = "Charging"
    case SecretSpace = "Secret Space"
    case Contacts = "Contacts"
    case EmailCleaner = "Email Cleaner"
    case Compress = "Compress"
}

struct HomeTabbarItem:Codable {
    
    var normalImage:String
    var heightImage:String
    var text:String
    
    enum Category: String, Codable {
        case normalImage,heightImage,text
    }
}
