//
//  PhotoDetailViewController.swift
//  PhoneManager
//
//  Created by edy on 2025/5/14.
//

import UIKit

class PhotoDetailViewController : BaseViewController {
    
    lazy var showView : PMScaleImageView = {
        let view = PMScaleImageView()
        return view
    }()
    
    lazy var closeButton : UIButton = {
        let view = UIButton(type: .custom)
        view.setImage(UIImage(named: "ic_close_charging"), for: .normal)
        view.addTarget(self, action: #selector(closeButtonAction), for: .touchUpInside)
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        
        self.view.addSubview(self.closeButton)
        self.closeButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.top.equalToSuperview().offset(statusBarHeight + 8)
            make.width.height.equalTo(28)
        }
        
        self.view.addSubview(self.showView)
        self.showView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(statusBarHeight + 44)
            make.bottom.equalTo(-safeHeight)
        }
        
        
        
    }
    @objc func closeButtonAction(){
        self.dismiss(animated: true)
    }
    

}
