//
//  RestoreButtonView.swift
//  PhoneManager
//
//  Created by 赵前 on 2025/4/20.
//

import Foundation
import UIKit

class RestoreButtonView : UIView {
    
    var submitCallBack : (()->Void) = {}
    
    lazy var imageView : UIImageView = {
        let imageView = UIImageView()
        imageView.image = UIImage(named: "ic_beifen")
        return imageView
    }()
    
    lazy var titleLabel : UILabel = {
        let label = UILabel()
        label.textAlignment = .left
        label.text = "Restore Backup"
        label.textColor = UIColor(red: 1, green: 1, blue: 1, alpha: 1)
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.isUserInteractionEnabled = true
        self.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(restoreAction))
        self.addGestureRecognizer(tap)
        
        
        self.addSubview(self.imageView)
        self.addSubview(self.titleLabel)
        
        
        self.imageView.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(94 * RScreenW())
        }
        self.titleLabel.snp.makeConstraints { make in
            make.left.equalTo(self.imageView.snp.right).offset(8 * RScreenW())
            make.centerY.equalToSuperview()
            make.height.equalTo(22)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    @objc func restoreAction(){
        submitCallBack()
    }
}
