//
//  DeleteButtonView.swift
//  PhoneManager
//
//  Created by 赵前 on 2025/4/19.
//

import Foundation
import UIKit

class DeleteButtonView : UIView {
    
    var submitCallBack : (()->Void) = {}
    
    lazy var deleteButton : UIButton = {
        let view = UIButton(type: .custom)
        view.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        view.setTitleColor(.white, for: .normal)
        view.clipsToBounds = true
        view.layer.cornerRadius = 12
        view.titleLabel?.font = UIFont.systemFont(ofSize: 16, weight: .semibold)
        view.setTitle("See Merge Preview", for: .normal)
        view.setImage(UIImage(named: "ic_hebing"), for: .normal)
        
        // 设置间距为 8
        let spacing: CGFloat = 8
        // 获取图片和文字的大小
        let imageSize = view.imageView?.image?.size ?? .zero
        let titleSize = view.titleLabel?.intrinsicContentSize ?? .zero
        // 计算 imageEdgeInsets 和 titleEdgeInsets
        view.imageEdgeInsets = UIEdgeInsets(top: 0, left: -spacing / 2, bottom: 0, right: spacing / 2)
        view.titleEdgeInsets = UIEdgeInsets(top: 0, left: spacing / 2, bottom: 0, right: -spacing / 2)
        
        view.addTarget(self, action: #selector(deleteButtonAction), for: .touchUpInside)
        return view
    }()
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        self.backgroundColor = .clear
        self.addSubview(self.deleteButton)
        
        self.deleteButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(55)
            make.right.equalToSuperview().offset(-55)
            make.height.equalTo(45)
            make.top.equalToSuperview().offset(16)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}


extension DeleteButtonView {
    
    
    @objc func deleteButtonAction(){
        submitCallBack()
    }
}
