//
//  ContactNavView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/18.
//

import Foundation
import UIKit

class ContactNavView : UIView {
    public var backButton:UIButton!
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        
        backgroundColor = .white

        backButton = UIButton()
        backButton.setImage(UIImage(named: "nav_back"), for: .normal)
        backButton.addTarget(self, action: #selector(backBtnClick), for: .touchUpInside)
        self.addSubview(backButton)
        
        backButton.snp.makeConstraints { make in
            
            make.centerY.equalTo(navCenterY)
            make.left.equalToSuperview().offset(marginLR)
            make.width.height.equalTo(iconWH)
        }
    }
    
    @objc private func backBtnClick() {
        self.responderViewController()?.navigationController?.popViewController(animated: true)
    }
}
