//
//  ContactBackupAlertView.swift
//  PhoneManager
//
//  Created by 赵前 on 2025/4/20.
//

import Foundation
import UIKit
class ContactBackupAlertView : UIView {
    
    var sureCallBack: (Bool)->Void = {isSure in }
    
    // 懒加载背景视图
    private lazy var backgroundView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear//UIColor(red: 1, green: 1, blue: 1, alpha: 0.4000)
        return view
    }()
    
    // 懒加载卡片视图
    private lazy var cardView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 10
        view.clipsToBounds = true
        return view
    }()
    
    // 懒加载标题标签
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "Would you like to back up your contacts before making any changes?"
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        label.textColor = UIColor(red: 0, green: 0, blue: 0, alpha: 1)
        label.textAlignment = .center
        label.numberOfLines = 0
        return label
    }()
    
    // 懒加载副标题标签
    private lazy var subtitleLabel: UILabel = {
        let label = UILabel()
        label.text = "Changes cannot be reversed if you do not back up your contacts"
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        label.textColor = UIColor(red: 0, green: 0, blue: 0, alpha: 1)
        label.numberOfLines = 0
        label.textAlignment = .center
        return label
    }()
    
    // 懒加载取消按钮
    private lazy var cancelButton: UIButton = {
        let button = UIButton()
        button.setTitle("No, Thanks", for: .normal)
        button.backgroundColor = .clear
        button.setTitleColor(UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1), for: .normal)
        button.titleLabel?.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        button.layer.cornerRadius = 23
        button.addTarget(self, action: #selector(dismissAlert), for: .touchUpInside)
        return button
    }()
    
    // 懒加载确认按钮
    private lazy var yesButton: UIButton = {
        let button = UIButton()
        button.setTitle("Back up", for: .normal)
        button.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        button.titleLabel?.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        button.setTitleColor(.white, for: .normal)
        button.layer.cornerRadius = 23
        button.addTarget(self, action: #selector(sureAlert), for: .touchUpInside)
        return button
    }()
   
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.backgroundColor = .clear//UIColor(red: 0, green: 0, blue: 0, alpha: 0.5000)
        setupViews()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupViews() {
        self.addSubview(backgroundView)
        backgroundView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        self.addSubview(cardView)
        cardView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(345)
            make.height.equalTo(288)
        }
        
        cardView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(28)
            make.left.right.equalToSuperview().inset(20)
            make.height.equalTo(84)
        }
        
        cardView.addSubview(subtitleLabel)
        subtitleLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
            make.left.right.equalToSuperview().inset(20)
            make.height.equalTo(40)
        }
        
        cardView.addSubview(yesButton)
        yesButton.snp.makeConstraints { make in
            make.top.equalTo(subtitleLabel.snp.bottom).offset(16)
            make.left.right.equalToSuperview().inset(20)
            make.height.equalTo(46)
        }
        
        cardView.addSubview(cancelButton)
        cancelButton.snp.makeConstraints { make in
            make.top.equalTo(yesButton.snp.bottom).offset(4)
            make.left.right.equalToSuperview().inset(20)
            make.height.equalTo(46)
        }
        
    }
    
    @objc private func dismissAlert() {
        UIView.animate(withDuration: AniDuration) {
            self.frame = CGRect(x: 0, y: ScreenH, width: ScreenW, height: ScreenH)
        } completion: { su in
            self.removeFromSuperview()
        }
        sureCallBack(false)
    }
    
    @objc private func sureAlert() {
        UIView.animate(withDuration: AniDuration) {
            self.frame = CGRect(x: 0, y: ScreenH, width: ScreenW, height: ScreenH)
        } completion: { su in
            self.removeFromSuperview()
        }
        sureCallBack(true)
    }
}
