//
//  ContactBackUpCompletedAlertView.swift
//  PhoneManager
//
//  Created by 赵前 on 2025/4/20.
//

import Foundation
import UIKit


class ContactBackUpCompletedAlertView : UIView {
    
    // 懒加载背景视图
    private lazy var backgroundView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 1, green: 1, blue: 1, alpha: 0.4000)
        return view
    }()
    
    // 懒加载卡片视图
    private lazy var cardView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 10
        view.clipsToBounds = true
        return view
    }()
    
    private lazy var imageView: UIImageView = {
        let view = UIImageView()
        view.backgroundColor = .clear
        view.image = UIImage(named: "ic_ok_duolicates")
        return view
    }()
    
    // 懒加载标题标签
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "Backing up is completed"
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        label.textAlignment = .center
        label.numberOfLines = 0
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.backgroundColor = UIColor(red: 0, green: 0, blue: 0, alpha: 0.5000)
        setupViews()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupViews() {
        self.addSubview(backgroundView)
        backgroundView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        self.addSubview(cardView)
        cardView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(175)
            make.height.equalTo(115)
        }
        
        cardView.addSubview(imageView)
        imageView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(20)
            make.width.height.equalTo(35)
            make.centerX.equalToSuperview()
        }
        
        
        cardView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(self.imageView.snp.bottom).offset(0)
            make.left.right.equalToSuperview().inset(20)
            make.height.equalTo(40)
        }
    }
}
