//
//  CustomDupHeaderView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/7.
//

import Foundation
import UIKit
class CustomDupPreHeaderView : UITableViewHeaderFooterView {
    
    var model : [ContactModel] = [] {
        didSet{
            DispatchQueue.main.async {
                self.tiplabel.text = "\(self.model.count) Contacts Merged"
            }
        }
    }
    
    // 当前的section
    var currentSection : Int = 0
    
    var headerCallback : ([ContactModel],Int)->Void = {array,currentSection in}
    
    var selectStatus : Bool = false
    
    
    lazy var tiplabel : UILabel = {
        let label = UILabel()
        label.text = "\(self.model.count) Contacts Merged"
        label.textAlignment = .left
        label.font = UIFont.systemFont(ofSize: 16, weight: .medium)
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
       return label
    }()
    
    lazy var deSelectButton : UIButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "ic_close_similar"), for: .normal)
        button.addTarget(self, action: #selector(removeCurrentData), for: .touchUpInside)
        return button
    }()
    

    
    override init(reuseIdentifier: String?) {
        super.init(reuseIdentifier: reuseIdentifier)
        self.backgroundColor = .clear
        self.addSubview(self.tiplabel)
        self.tiplabel.snp.makeConstraints { make in
            make.left.top.equalToSuperview()
            make.width.equalTo(200)
            make.height.equalTo(22)
        }
        
        
        
        self.addSubview(self.deSelectButton)
        self.deSelectButton.snp.makeConstraints { make in
            make.width.equalTo(20)
            make.height.equalTo(20)
            make.right.equalToSuperview()
            make.centerY.equalTo(self.tiplabel.snp.centerY)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

extension CustomDupPreHeaderView {
    
    @objc func removeCurrentData(){
        self.headerCallback(self.model,currentSection)
    }
}
