//
//  CustomDupHeaderView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/7.
//

import Foundation
import UIKit
class CustomDupHeaderView : UITableViewHeaderFooterView {
    
    var model : [ContactModel] = [] {
        didSet{
            DispatchQueue.main.async {
                self.tiplabel.text = "\(self.model.count) Duplicate Contacts"
            }
        }
    }
    
    var headerCallback : ([ContactModel])->Void = {array in}
    
    var selectStatus : Bool = false
    
    
    lazy var tiplabel : UILabel = {
        let label = UILabel()
        label.text = "\(self.model.count) Duplicate Contacts"
        label.textAlignment = .left
        label.font = UIFont.systemFont(ofSize: 16, weight: .medium)
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
       return label
    }()
    
    lazy var subLabel : UILabel = {
        let selectLabel = UILabel()
        selectLabel.textAlignment = .right
        selectLabel.textColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        if self.selectStatus {
            selectLabel.text = "Select All"
        }else{
            selectLabel.text = "Deselect all"
        }
       
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(cellSelectTap))
        selectLabel.isUserInteractionEnabled = true
        selectLabel.addGestureRecognizer(tap)
        return selectLabel
    }()
    
    override init(reuseIdentifier: String?) {
        super.init(reuseIdentifier: reuseIdentifier)
        self.backgroundColor = .clear
        self.addSubview(self.tiplabel)
        self.tiplabel.snp.makeConstraints { make in
            make.left.top.equalToSuperview()
            make.width.equalTo(200)
            make.height.equalTo(22)
        }
        
        
        
        self.addSubview(self.subLabel)
        self.subLabel.snp.makeConstraints { make in
            make.width.equalTo(100)
            make.height.equalTo(22)
            make.right.equalToSuperview()
            make.centerY.equalTo(self.tiplabel.snp.centerY)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

extension CustomDupHeaderView {
    
    @objc func cellSelectTap(){
        if self.selectStatus {
            self.subLabel.text = "Deselect all"
        }else {
            self.subLabel.text = "Select All"
        }
        self.headerCallback(self.model)
    }
}
