//
//  CustomContactDupTableViewCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/6.
//

import Foundation
import UIKit

class CustomContactDupTableViewCell : UITableViewCell {
    
    var indexPath: IndexPath?
    
    var cellSelectCallCack : (IndexPath,Bool)->Void = {index,choose in}
    
    var model : ContactModel?{
        didSet{
            self.nameLabel.text = model?.fullName
            if let numbers = model?.phoneNumber {
                self.numberLabel.text = getPhoneNumberString(photoNumbers:numbers)
            }else {
                self.numberLabel.text = ""
            }
        }
    }
    
    
    lazy var backView :  UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        view.clipsToBounds = true
        view.layer.cornerRadius = 12
        return view
    }()
    
    
    lazy var nameLabel :  UILabel = {
        let label = UILabel()
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        return label
    }()
    
    lazy var numberLabel :  UILabel = {
        let label = UILabel()
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        return label
    }()
    
    lazy var selectButton : UIButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "ic_sel_com"), for: .normal)
        button.setImage(UIImage(named: "ic_unsel_com_red"), for: .selected)
        button.addTarget(self, action: #selector(selectContact(_:)), for: .touchUpInside)
        return button
    }()
    
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        
        self.selectionStyle = .none
        
        self.contentView.addSubview(self.backView)
        self.backView.addSubview(self.nameLabel)
        self.backView.addSubview(self.numberLabel)
        self.backView.addSubview(self.selectButton)
        
        self.backView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(71)
        }
        self.nameLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16 * RScreenH())
            make.top.equalToSuperview().offset(16)
            make.width.equalTo(210)
            make.height.equalTo(22)
        }
        self.numberLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16 * RScreenH())
            make.top.equalTo(self.nameLabel.snp.bottom).offset(0)
            make.right.equalTo(self.selectButton.snp.left).offset(0)
            make.height.equalTo(20)
        }
        
        self.selectButton.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.centerY.equalToSuperview()
            make.right.equalToSuperview().offset(-16 * RScreenW())
        }
        
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

extension CustomContactDupTableViewCell {
    @objc func selectContact(_ sender: UIButton) {
        sender.isSelected = !sender.isSelected
        if let indexPath = self.indexPath {
            self.cellSelectCallCack(indexPath,sender.isSelected)
        }
    }
    
    
    func getPhoneNumberString(photoNumbers : [String]) -> String{
        let tempNumbers = photoNumbers
        let nonEmptyStrings = tempNumbers.filter {!$0.isEmpty}
        if nonEmptyStrings.count <= 0 {
            return ""
        }
        return photoNumbers.joined(separator: " / ")
    }
}



