//
//  CustomContactDupTableViewCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/6.
//

import Foundation
import UIKit

class CustomContactDupPreTableViewCell : UITableViewCell {
    
    var indexPath: IndexPath?
    
    var cellSelectCallCack : (IndexPath,Bool)->Void = {index,choose in}
    
    var model : [ContactModel] = [] {
        didSet{
            DispatchQueue.main.async {
                if self.model.count > 0 {
                    self.nameLabel.text = self.model.first?.fullName
                    self.numberLabel.text = self.getPhoneNumberString(contacts: self.model)
                }else {
                    self.nameLabel.text = ""
                    self.numberLabel.text = ""
                }
            }
        }
    }
    
    
    lazy var backView :  UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        view.clipsToBounds = true
        view.layer.cornerRadius = 12
        return view
    }()
    
    
    lazy var nameLabel :  UILabel = {
        let label = UILabel()
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        return label
    }()
    
    lazy var numberLabel :  UILabel = {
        let label = UILabel()
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        return label
    }()
    
    lazy var moreButton : UIButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "icon_left_setting_grey"), for: .normal)
        return button
    }()
    
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        
        self.selectionStyle = .none
        
        self.contentView.addSubview(self.backView)
        self.backView.addSubview(self.nameLabel)
        self.backView.addSubview(self.numberLabel)
        self.backView.addSubview(self.moreButton)
        
        self.backView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(71)
        }
        self.nameLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16 * RScreenH())
            make.top.equalToSuperview().offset(16)
            make.width.equalTo(210)
            make.height.equalTo(22)
        }
        self.numberLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16 * RScreenH())
            make.top.equalTo(self.nameLabel.snp.bottom).offset(0)
            make.right.equalTo(self.moreButton.snp.left).offset(0)
            make.height.equalTo(20)
        }
        
        self.moreButton.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.centerY.equalToSuperview()
            make.right.equalToSuperview().offset(-16 * RScreenW())
        }
        
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

extension CustomContactDupPreTableViewCell {
    
    
    func getPhoneNumberString(contacts : [ContactModel]) -> String{
        var photoNumbers : [String] = []
        for item in contacts {
            if let tempNumbers = item.phoneNumber {
                photoNumbers = photoNumbers + tempNumbers
            }
        }
        let nonEmptyStrings = photoNumbers.filter {!$0.isEmpty}
        if nonEmptyStrings.count <= 0 {
            return ""
        }
        return photoNumbers.joined(separator: " / ")
    }
}



