//
//  ContactBackupViewController.swift
//  PhoneManager
//
//  Created by 赵前 on 2025/4/19.
//

import Foundation
import UIKit

class ContactBackupViewController : BaseViewController {
    
    var dataSourceModel :  [BackupInfoModel]?
    
    
    // 总数据
    var dataSourceAllModel : ContactModuleModel?
    
    lazy var navView : ContactNavView = {
        let view = ContactNavView()
        return view
    }()
    
    lazy var emptyView : ContactNoBackUpView = {
        let view = ContactNoBackUpView()
        return view
    }()
    lazy var normalView : ContactBackUpNormalView = {
        let view = ContactBackUpNormalView()
        return view
    }()
    
    
    // 默认页面
    func setDefaultPage(){
        self.normalView.removeFromSuperview()
        self.view.addSubview(self.emptyView)
        
        self.emptyView.snp.makeConstraints { make in
            make.top.equalTo(self.navView.snp.bottom).offset(0)
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview()
        }
    }
    
    // 默认页面
    func setNormalPage(){
        self.emptyView.removeFromSuperview()
        self.view.addSubview(self.normalView)
        
        self.normalView.snp.makeConstraints { make in
            make.top.equalTo(self.navView.snp.bottom).offset(0)
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview()
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.view.backgroundColor = .white
        
        self.view.addSubview(self.navView)
        self.navView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(statusBarHeight + 44)
        }
        
        self.setDefaultPage()
        
        
        self.emptyView.newBackupCallback = {
            // 备份数据
            let vm = BackupViewModel()
            
            // 备份之前先看看是否有可用的联系人
            if let data = self.dataSourceAllModel {
                if data.allContacts.count > 0 {
                    vm.backupAllContacts(data.allContacts) { finished, error in
                        if let error = error {
                            Print("添加失败，\(error.localizedDescription)")
                        }
                        DispatchQueue.main.async {
                            // 再次请求数据 重新刷新页面
                            let buAlertVc = ContactBackUpCompletedAlertView(frame: self.view.bounds)
                            self.view.addSubview(buAlertVc)
                            buAlertVc.alpha = 0
                            UIView.animate(withDuration: AniDuration - 0.2) {
                                buAlertVc.alpha = 1
                            }
                            DispatchQueue.main.asyncAfter(deadline: .now() + 1) {
                                buAlertVc.removeFromSuperview()
                                self.updateCurrentPageData()
                            }
                        }
                    }
                }else {
                    let buAlertVc = ContactBackUpNoDataAlertView(frame: (cWindow?.bounds)!)
                    cWindow?.addSubview(buAlertVc)
                    buAlertVc.alpha = 0
                    UIView.animate(withDuration: AniDuration - 0.2) {
                        buAlertVc.alpha = 1
                    }
                    DispatchQueue.main.asyncAfter(deadline: .now() + 1) {
                        buAlertVc.removeFromSuperview()
                    }
                }
            }
            
        }
        
        self.normalView.isClearAllCallBack = {
            DispatchQueue.main.async {
                self.updateCurrentPageData()
            }
        }
    }
}

extension ContactBackupViewController {
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        // 请求下数据
        self.updateCurrentPageData()
        
    }
    
    func updateCurrentPageData(){
        let vm = BackupViewModel()
        vm.retrieveContactsFromBackup {[weak self] info, error in
            guard let self else {return}
            if error != nil {
                Print("取出备份错误\(String(describing: error?.localizedDescription))")
                return
            }
            
            // 备份是否有数据
            DispatchQueue.main.async {
                if info!.count <= 0 {
                    self.setDefaultPage()
                }else{
                    self.setNormalPage()
                    self.dataSourceModel = info
                    self.normalView.dataSourceModel = info ?? []
                    self.normalView.dataSourceAllModel = self.dataSourceAllModel?.allContacts
                    self.normalView.tableView.reloadData()
                }
            }
            
        }
    }
}


