//
//  QualityView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import Foundation

class QualityView : UIView{
    
    var type : Int = 0
    
    var callBack : callBack<Any> = {type in}
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        self.layer.cornerRadius = 12
        self.clipsToBounds = true
        
        self.addSubview(self.tipLabel)
        self.addSubview(self.detailTiplabel)
        self.addSubview(self.selectedImageView)
        
        self.tipLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.top.equalToSuperview().offset(12)
            make.width.equalTo(276)
            make.height.equalTo(20)
        }
        self.detailTiplabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-12)
            make.width.equalTo(276)
            make.height.equalTo(17)
        }
        self.selectedImageView.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-16)
            make.centerY.equalToSuperview()
            make.width.equalTo(24)
            make.height.equalTo(24)
        }
        
        self.layer.borderColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1).cgColor
        
        // 给自身添加手势
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(selectClick))
        self.isUserInteractionEnabled = true
        self.addGestureRecognizer(tap)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var tipLabel: UILabel = {
        let label = UILabel()
        label.text = "Low quality"
        label.textAlignment = .left
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 14, weight: .bold)
        label.backgroundColor = .clear
        return label
    }()
    
    lazy var detailTiplabel: UILabel = {
        let label = UILabel()
        label.text = "Compress up to 80% of the size"
        label.textAlignment = .left
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 12, weight: .regular)
        label.backgroundColor = .clear
        return label
    }()
    lazy var selectedImageView: UIImageView = {
        let imageView = UIImageView()
        imageView.backgroundColor = .clear
        imageView.image = UIImage(named: "ic_sel_com")
        imageView.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(selectClick))
        imageView.addGestureRecognizer(tap)
        return imageView
    }()
    
    @objc func selectClick(){
        callBack(self.type)
    }
    
}
