//
//  CompressTipView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import Foundation
class CompressTipView : UIView {
    
    var callBack:callBack<Any> = {allow in}
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(self.backView)
        self.backView.addSubview(self.contentView)
        self.contentView.addSubview(self.tipLabel)
        self.contentView.addSubview(self.detailTiplabel)
        self.contentView.addSubview(self.shotView)
        self.contentView.addSubview(self.noAllowBtn)
        self.contentView.addSubview(self.lineView)
        self.contentView.addSubview(self.deleteBtn)
        
        self.backView.snp.makeConstraints { make in
            make.width.height.left.top.equalToSuperview()
        }
        self.contentView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(53)
            make.right.equalToSuperview().offset(-53)
            make.height.equalTo(310)
            make.centerY.equalToSuperview()
        }
        self.tipLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.height.equalTo(44)
        }
        
        self.detailTiplabel.snp.makeConstraints { make in
            make.top.equalTo(self.tipLabel.snp.bottom).offset(2)
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.height.equalTo(36)
        }
        self.shotView.snp.makeConstraints { make in
            make.top.equalTo(self.detailTiplabel.snp.bottom).offset(16)
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.height.equalTo(152)
        }
        self.noAllowBtn.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview()
            make.width.equalTo(134.25)
            make.height.equalTo(44)
        }
        self.lineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.centerX.equalTo(self.shotView.snp.centerX)
            make.width.equalTo(2)
            make.height.equalTo(44)
        }
        self.deleteBtn.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.right.equalToSuperview()
            make.width.equalTo(134.25)
            make.height.equalTo(44)
        }
        
    }
    
    lazy var backView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0, green: 0, blue: 0, alpha: 0.5000)
        return view
    }()
    
    lazy var contentView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        view.clipsToBounds = true
        view.layer.cornerRadius = 14
        return view
    }()
    
    lazy var tipLabel: UILabel = {
        let label = UILabel()
        label.text = "Allow ”Al Cleaner“ to delete 2 photos?"
        label.textAlignment = .center
        label.numberOfLines = 0
        label.font = UIFont.systemFont(ofSize: 17, weight: .bold)
        label.backgroundColor = .clear
        return label
    }()
    
    lazy var detailTiplabel: UILabel = {
        let label = UILabel()
        label.text = "These photos will be deleted from iCloud Photos on all your devices."
        label.textAlignment = .center
        label.numberOfLines = 0
        label.font = UIFont.systemFont(ofSize: 13, weight: .regular)
        label.backgroundColor = .clear
        return label
    }()
    
    lazy var shotView: UIView = {
        let view = UIView()
        view.backgroundColor = .gray
        return view
    }()
    lazy var noAllowBtn: UIButton = {
        let button = UIButton()
        button.setTitle("Don't Allow", for: .normal)
        button.setTitleColor(UIColor(red: 0, green: 0.48, blue: 1, alpha: 1), for: .normal)
        button.addTarget(self, action: #selector(noAllowClick), for: .touchUpInside)
        return button
    }()
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0.24, green: 0.24, blue: 0.26, alpha: 0.3600)
        return view
    }()
    lazy var deleteBtn: UIButton = {
        let button = UIButton()
        button.setTitle("Delete", for: .normal)
        button.setTitleColor(UIColor(red: 0, green: 0.48, blue: 1, alpha: 1), for: .normal)
        button.addTarget(self, action: #selector(deleteClick), for: .touchUpInside)
        return button
    }()
    
    
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func noAllowClick(){
        self.removeFromSuperview()
        callBack(false)
    }
    
    @objc func deleteClick(){
        self.removeFromSuperview()
        callBack(true)
    }
    
    
}
