//
//  CpmpressSwitchView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/3.
//

import Foundation

class CompressSwitchView : UIView {
    
    var callBack: callBack<CompressType> = {flag in }
    
    var currentButton : UIButton?
    
    lazy var leftButton : UIButton = {
        let button = UIButton()
        button.layer.cornerRadius = 4
        button.clipsToBounds = true
        button.setTitle("Photos", for: .normal)
        button.addTarget(self, action: #selector(selectedButtonAction(_:)), for: .touchUpInside)
        button.setTitleColor(UIColor(red: 0.7, green: 0.7, blue: 0.7, alpha: 1), for: .normal)
        button.tag = 1000
        return button
    }()
    
    lazy var rightButton : UIButton = {
        let button = UIButton()
        button.layer.cornerRadius = 4
        button.clipsToBounds = true
        button.setTitle("Videos", for: .normal)
        button.addTarget(self, action: #selector(selectedButtonAction(_:)), for: .touchUpInside)
        button.setTitleColor(UIColor(red: 0.7, green: 0.7, blue: 0.7, alpha: 1), for: .normal)
        button.tag = 1001
        return button
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.backgroundColor = .clear
        
        self.addSubview(self.leftButton)
        self.addSubview(self.rightButton)
        
        self.leftButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(4)
            make.top.equalToSuperview().offset(4)
            make.bottom.equalToSuperview().offset(-4)
            make.width.equalTo(self.snp.width).multipliedBy(0.5).offset(-6)
        }
        
        self.rightButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-4)
            make.top.equalToSuperview().offset(4)
            make.bottom.equalToSuperview().offset(-4)
            make.left.equalTo(self.leftButton.snp.right).offset(4)
        }
        
        
        // 初始化的时候设置默认值
        self.currentButton = self.leftButton
        self.currentButton?.setTitleColor(UIColor(red: 0, green: 0.51, blue: 1, alpha: 1), for: .normal)
        self.currentButton?.backgroundColor = .white
        
    }
    
   
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    @objc func selectedButtonAction(_ sender : UIButton){
        if sender != self.currentButton{
            self.currentButton?.setTitleColor(UIColor(red: 0.7, green: 0.7, blue: 0.7, alpha: 1), for: .normal)
            self.currentButton?.backgroundColor = .clear
        }
        sender.setTitleColor(UIColor(red: 0, green: 0.51, blue: 1, alpha: 1), for: .normal)
        sender.backgroundColor = .white
        self.currentButton = sender
        if (sender.tag - 1000) == 0 {
            self.callBack(.compressPhoto)
        }else{
            self.callBack(.compressVideo)
        }
        
    }
    
}
