//
//  CompressCustomHeaderView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import Foundation

class CompressCustomHeaderView: UICollectionReusableView{
    
    var  filterBoxModel : ResourceFilterBoxModel?
    
    var sortViewSubmitCallBack : (ResourceFilterBoxModel)->Void = {model in}
    
    var modeData = [AssetModel]() {
        didSet{
            // 计算图片总大小
            var sum = 0.0
            // 计算可节省大小
            var saveSum = 0.0
            for model in self.modeData{
                sum = sum + model.assetSize
                saveSum = saveSum + model.assetSize * 0.5
            }
            self.siezLabel.text = formatFileSize(sum)
            self.saveSizeLabel.text = formatFileSize(saveSum)
        }
    }
    
    lazy var titlelabel :UILabel = {
        let label = UILabel()
        label.text = "Compress"
        label.textAlignment = .left
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        return label
    }()
    
    // 筛选按钮
    lazy var filterButton :  UIButton =  {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "Frame 1"), for: .normal)
        button.setTitle("largest", for: .normal)
        button.layer.cornerRadius = 14
        button.clipsToBounds = true
        button.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 0.1000)
        button.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .semibold)
        button.titleEdgeInsets = UIEdgeInsets(top: 0, left: 5, bottom: 0, right: 0)
        button.setTitleColor(UIColor(red: 0.07, green: 0.07, blue: 0.07, alpha: 1), for: .normal)
        button.addTarget(self, action: #selector(filterButtonAction), for: .touchUpInside)
        button.isHidden = false
        return button
    }()
    
    lazy var siezLabel :UILabel = {
        let label = UILabel()
        label.text = "1.02 GB"
        label.textAlignment = .left
        label.textColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 14, weight: .regular)
        return label
    }()
    
    lazy var changeView :CompressSwitchView = {
        let view = CompressSwitchView()
        view.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        view.layer.cornerRadius = 8
        view.clipsToBounds = true
        return view
    }()
    
    lazy var tipView :UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "ic_cmpress_home_nor")
        return view
    }()
    
    lazy var tipLabel :UILabel = {
        let label = UILabel()
        label.text = "Compress your media files and save up to"
        label.textAlignment = .left
        label.numberOfLines = 0
        label.textColor = UIColor(red: 0.7, green: 0.7, blue: 0.7, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 12, weight: .regular)
        return label
    }()
    
    lazy var saveSizeLabel :UILabel = {
        let label = UILabel()
        label.text = "511MB"
        label.textAlignment = .right
        label.textColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 16, weight: .bold)
        return label
    }()
    
    
    
    
    private func setUI(){
        
        self.addSubview(self.titlelabel)
        self.addSubview(self.filterButton)
        self.addSubview(self.siezLabel)
        self.addSubview(self.changeView)
        self.addSubview(self.tipView)
        self.addSubview(self.tipLabel)
        self.addSubview(self.saveSizeLabel)
        
        self.titlelabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(0)
            make.top.equalToSuperview().offset(14)
            make.height.equalTo(28)
        }
        
        self.filterButton.snp.makeConstraints { make in
            make.centerY.equalTo(self.titlelabel.snp.centerY)
            make.right.equalToSuperview().offset(0)
            make.height.equalTo(28)
            make.width.equalTo(98)
        }
        
        self.siezLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(self.filterButton.snp.bottom).offset(8)
            make.height.equalTo(20)
        }
        self.changeView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(self.siezLabel.snp.bottom).offset(12)
            make.height.equalTo(46)
        }
        self.tipView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(self.changeView.snp.bottom).offset(15)
            make.width.height.equalTo(28)
        }
        self.tipLabel.snp.makeConstraints { make in
            make.left.equalTo(self.tipView.snp.right).offset(4)
            make.width.equalTo(206 * RScreenW())
            make.height.equalTo(34)
            make.centerY.equalTo(self.tipView.snp.centerY)
        }
        self.saveSizeLabel.snp.makeConstraints { make in
            make.left.equalTo(self.tipLabel.snp.right).offset(4)
            make.right.equalTo(0)
            make.height.equalTo(22)
            make.centerY.equalTo(self.tipView.snp.centerY)
        }
    }
    
    
    @objc func filterButtonAction(){
        if let cWindow = cWindow {
            // 这里将原来的数据传递过去
            
            let filterView : ResourceFilterBoxView = ResourceFilterBoxView.init(frame: cWindow.bounds,startDate: self.filterBoxModel?.startDate,endDate: self.filterBoxModel?.endDate,sortType: self.filterBoxModel?.sortType)
            // 添加毛玻璃效果
            cWindow.showBlur()
            
            cWindow.addSubview(filterView)
            filterView.submitCallBack = {model in
                self.filterBoxModel = model
                DispatchQueue.main.async {
                    self.filterButton.setTitle(model.sortType.rawValue, for: .normal)
                }
                self.sortViewSubmitCallBack(model)
            }
        }
    }
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.backgroundColor = .white
        setUI()
        
        
        
    }
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
        setUI()
    }
}
