//
//  CompressSelectCell.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import Foundation
import Photos




typealias CompressSelectCellCallback = (AssetModel,Bool)->Void



class CompressSelectCell : UICollectionViewCell {
    
    var indexPath : IndexPath?
    
    var callBack : CompressSelectCellCallback = {model,choose in}
    
    var currentMediaType : CompressType = .compressPhoto {
        didSet{
            DispatchQueue.main.async {
                if self.currentMediaType == .compressPhoto{
                    self.playImageView.isHidden = true
                }else{
                    self.playImageView.isHidden = false
                }
            }
        }
    }
    
    var model : AssetModel? {
        didSet{
            guard let model = self.model else {return}
            let placeImage = currentMediaType == .compressPhoto ? "videosmoren" : "othermoren"
            self.backImageView.asset.load(withLocalIdentifier:model.localIdentifier,placeholder: UIImage.init(named: placeImage))
            
            
//            self.backImageView.image = UIImage()
//            if self.currentMediaType == .compressPhoto {
//                let viewModel = CompressViewModel()
//                viewModel.getImageFromAssetIdentifier(identifier: model.localIdentifier) {[weak self] image in
//                    guard let self else { return}
//                    DispatchQueue.main.async {
//                        self.backImageView.image = image
//                    }
//                }
//            }else {
//                PhotoAndVideoMananger.mananger.getVideoImageByIdent(ident: model) { image in
//                    DispatchQueue.main.async {
//                        self.backImageView.image = image
//                    }
//                } errorHandler: {
//                    print("获取视频图片资源失败")
//                }
           // }
            // 这里不再进行计算了  直接按照50%的去计算
            let saveSize = model.assetSize/2
            let sizeKB : Double = saveSize/1000
            DispatchQueue.main.async {
                if sizeKB < 1000{
                    self.saveSizeLabel.text = String(format: "Save %.2f KB" ,sizeKB)
                }else if sizeKB < (1000 * 1000) && sizeKB > 1000{
                    self.saveSizeLabel.text = String(format: "Save %.2f MB" ,sizeKB/1000)
                }else{
                    self.saveSizeLabel.text = String(format: "Save %.2f GB" ,sizeKB/(1000 * 1000))
                }
            }
        }
    }
    
    
    lazy var backImageView: UIImageView = {
        let view = UIImageView()
        view.isUserInteractionEnabled = true
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        view.layer.masksToBounds = true
        view.layer.cornerRadius = 12
        return view
    }()
    
    lazy var playImageView: UIImageView = {
        let view = UIImageView()
        view.backgroundColor = .clear
        view.image = UIImage(named: "btn_play_home")
        view.isUserInteractionEnabled = true
        view.isHidden = true
        return view
    }()
    
    
    lazy var saveSizeView: UIView = {
        let view = UIView()
        view.layer.masksToBounds = true
        view.layer.cornerRadius = 4
        view.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        return view
    }()
    
    lazy var saveSizeLabel: UILabel = {
        let view = UILabel()
        view.textAlignment = .left
        view.textColor = UIColor(red: 1, green: 1, blue: 1, alpha: 1)
        view.font = UIFont.systemFont(ofSize: 12, weight: .regular)
        view.text = "Save 1.3MB"
        return view
    }()
    
    lazy var moreImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "icon_left_setting_grey")
        view.backgroundColor = .clear
        return view
    }()
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
//        self.isUserInteractionEnabled = true
//        let tap = UITapGestureRecognizer()
//        tap.addTarget(self, action: #selector(imageClick))
//        self.addGestureRecognizer(tap)
        
        self.addSubview(self.backImageView)
        self.backImageView.addSubview(self.playImageView)
        self.addSubview(self.saveSizeView)
        self.saveSizeView.addSubview(self.saveSizeLabel)
        self.saveSizeView.addSubview(self.moreImageView)
        
        self.backImageView.snp.makeConstraints { make in
            make.left.right.height.width.equalToSuperview()
        }
        self.playImageView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.height.equalTo(43)
        }
        self.saveSizeView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(12)
            make.bottom.equalToSuperview().offset(-12)
            make.height.equalTo(25)
            make.width.equalTo(120)
        }
        self.saveSizeLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(8)
            make.centerY.equalToSuperview()
            make.height.equalTo(25)
            make.width.equalTo(105)
        }
        
        self.moreImageView.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-4)
            make.centerY.equalToSuperview()
            make.height.width.equalTo(16)
        }
        
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
//    @objc func imageClick(){
//
//        
//    }
    
}
