//
//  ChargeView.swift
//  PhoneManager
//
//  Created by edy on 2025/3/26.
//

import UIKit
import AVFoundation

class ChargeView:UIView {
    
    var clickCallBack : (ChargeDataModel,Int)->Void = {model,index in}
    
    let footerID:String = "footerID"
    
    lazy var models:[ChargeDataModel] = []
    
    lazy var collectionView:UICollectionView = {
        
        let cY:CGFloat = 0.RW()
        
        let layout = WaterfallMutiSectionFlowLayout()
        layout.delegate = self
        let sview:UICollectionView = UICollectionView.init(frame: CGRect(x: marginLR, y: cY, width: width - 2 * marginLR, height: height - cY),  collectionViewLayout: layout)
        
        sview.dataSource = self
        sview.delegate = self
        sview.showsVerticalScrollIndicator = false
        sview.register(ChargeViewCollectionCell.self, forCellWithReuseIdentifier: ChargeViewCollectionCell.identifiers)
        sview.register(
            ChargeHeaderView.self,
            forSupplementaryViewOfKind: UICollectionView.elementKindSectionHeader,
            withReuseIdentifier: ChargeHeaderView.identifiers
        )
        
        sview.register(
            UICollectionReusableView.self,
            forSupplementaryViewOfKind: UICollectionView.elementKindSectionFooter,
            withReuseIdentifier: footerID
        )
        
        if #available(iOS 11.0, *) {
            sview.contentInsetAdjustmentBehavior = .never
        }
        sview.contentInset = UIEdgeInsets(top: 0, left: 0, bottom: safeHeight + 16, right: 0)
        
        sview.backgroundColor = .clear
        return sview
        
    }()
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        models = loadVideoItems()
        
        setupUI()
    }
    
    
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        
        backgroundColor = .white
        
        self.addSubview(collectionView)
    }
}


extension ChargeView:WaterfallMutiSectionDelegate,UICollectionViewDataSource,UICollectionViewDelegate {
    
    func heightForRowAtIndexPath(collectionView collection: UICollectionView, layout: WaterfallMutiSectionFlowLayout, indexPath: IndexPath, itemWidth: CGFloat) -> CGFloat {
        
        return 297
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        
        return models.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: ChargeViewCollectionCell.identifiers, for: indexPath) as! ChargeViewCollectionCell
        cell.flag = indexPath.row
        cell.model = models[indexPath.row]
        
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        
        let model = models[indexPath.row]
        
        self.clickCallBack(model,indexPath.row)
        
    }
    
    func collectionView(_ collectionView: UICollectionView,
                        viewForSupplementaryElementOfKind kind: String,
                        at indexPath: IndexPath) -> UICollectionReusableView {
        
        if kind == UICollectionView.elementKindSectionHeader {
            let header = collectionView.dequeueReusableSupplementaryView(
                ofKind: kind,
                withReuseIdentifier: ChargeHeaderView.identifiers,
                for: indexPath
            ) as! ChargeHeaderView
            
            header.titleLabel.text = "Charging Animation"
            return header
        }else {
            
            let footer = collectionView.dequeueReusableSupplementaryView(
                ofKind: kind,
                withReuseIdentifier: footerID,
                for: indexPath
            )
            
            return footer
        }
        
    }
    
    
    func columnNumber(collectionView collection: UICollectionView, layout: WaterfallMutiSectionFlowLayout, section: Int) -> Int {
        
        return 2
    }
    
    func lineSpacing(collectionView collection: UICollectionView, layout: WaterfallMutiSectionFlowLayout, section: Int) -> CGFloat {
        
        return 11
    }
    
    func interitemSpacing(collectionView collection: UICollectionView, layout: WaterfallMutiSectionFlowLayout, section: Int) -> CGFloat {
        
        return 11
    }
    
    func referenceSizeForHeader(collectionView collection: UICollectionView, layout: WaterfallMutiSectionFlowLayout, section: Int) -> CGSize {
        
        return CGSize(width: collection.width, height: 56)
    }
    
}


class ChargeHeaderView: UICollectionReusableView {
    
    static let identifiers = "ChargeHeaderViewID"
    
    let titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.boldSystemFont(ofSize: 20)
        label.textColor = UIColor.colorWithHex(hexStr: black3Color)
        label.translatesAutoresizingMaskIntoConstraints = false
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupViews()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupViews() {
        backgroundColor = .clear
        addSubview(titleLabel)
        
        NSLayoutConstraint.activate([
            titleLabel.leadingAnchor.constraint(equalTo: leadingAnchor, constant: 0),
            titleLabel.trailingAnchor.constraint(equalTo: trailingAnchor, constant: 0),
            titleLabel.topAnchor.constraint(equalTo: topAnchor),
            titleLabel.bottomAnchor.constraint(equalTo: bottomAnchor)
        ])
    }
}
