//
//  ChargeInfoSettingView.swift
//  PhoneManager
//
//  Created by edy on 2025/3/27.
//

import UIKit

class ChargeInfoSettingView:UIView {
    
    var settingCallBack:(Bool,Int)->Void = {pro,flag in}
    
    var model : ChargeDataModel?
    
    var flag : Int?
    
    lazy var settingBtn:UIButton = {
        
        let sview:UIButton = UIButton()
        
        sview.backgroundColor = UIColor.colorWithHex(hexStr: mColor)
        sview.setTitle("Set Animation", for: .normal)
        sview.setTitleColor(UIColor.white, for: .normal)
        sview.titleLabel?.font = .systemFont(ofSize: 16, weight: .bold)
        
        sview.width = width - 2 * marginLR
        sview.height = 46
        sview.centerX = width / 2
        sview.y = marginLR
        
        sview.layer.cornerRadius = sview.height / 2
        sview.layer.masksToBounds = true
        sview.addTarget(self, action: #selector(settingBtnClick), for: .touchUpInside)
        
        return sview
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        
        backgroundColor = .white
        
        self.addSubview(settingBtn)
    }
    
    @objc func settingBtnClick() {
        
        self.settingCallBack(self.model?.isFree ?? false,self.flag!)
    }
    
    
    
    
    
}
