//
//  ChargeGuideOpenShortcutsView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/7.
//

import Foundation
class ChargeGuideOpenShortcutsView : UIView {
    var callback :callBack<Any> = {text in}
    
    lazy var backView : UIImageView = {
        let view = UIImageView()
        return view
    }()
    
    lazy var openButton : UIButton = {
        let view = UIButton()
        view.setTitle("Open Shortcuts", for: .normal)
        view.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        view.setTitleColor(.white, for: .normal)
        view.clipsToBounds = true
        view.layer.cornerRadius = 8
        view.addTarget(self, action: #selector(getOpen), for: .touchUpInside)
        return view
    }()
    
    lazy var nextButton : UIButton = {
        let view = UIButton()
        view.setTitle("Next", for: .normal)
        view.backgroundColor = UIColor(red: 0.95, green: 0.96, blue: 0.99, alpha: 1)
        view.setTitleColor(.black, for: .normal)
        view.clipsToBounds = true
        view.layer.cornerRadius = 8
        view.addTarget(self, action: #selector(getNext), for: .touchUpInside)
        return view
    }()
    
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        
        
        self.addSubview(self.backView)
        self.addSubview(self.openButton)
        self.addSubview(self.nextButton)
        
        self.backView.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
        self.openButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.bottom.equalToSuperview().offset(-150)
            make.height.equalTo(46)
        }
        
        self.nextButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.bottom.equalToSuperview().offset(-70)
            make.height.equalTo(46)
        }
    }
    @objc func getOpen(){
        
        // 创建快捷指令 APP 的 URL
        if let shortcutsURL = URL(string: "shortcuts://") {
            // 检查设备是否能打开该 URL
            if UIApplication.shared.canOpenURL(shortcutsURL) {
                // 打开快捷指令 APP
                UIApplication.shared.open(shortcutsURL, options: [:], completionHandler: { (success) in
                    if success {
                        print("成功跳转至快捷指令 APP")
                    } else {
                        print("无法跳转至快捷指令 APP")
                    }
                })
            } else {
                print("设备不支持打开快捷指令 APP")
            }
        }
    }
    
    @objc func getNext(){
        callback("next")
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
