//
//  ChargeGuideEndView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/7.
//

import Foundation

class ChargeGuideEndView : UIView{
    var callback : callBack<Any> = {text in}
    
    lazy var backView : UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "image_76")
        return view
    }()
    
    lazy var tipTitleLabel:UILabel={
        let view = UILabel()
        view.text = "Great Job!"
        view.backgroundColor = .clear
        view.numberOfLines = 0
        view.textAlignment = .center
        view.font = UIFont.systemFont(ofSize: 18, weight: .bold)
        view.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        return view
    }()
    lazy var detailTipTitleLabel:UILabel={
        let view = UILabel()
        view.text = "Let's find your perfect charging animation."
        view.numberOfLines = 0
        view.backgroundColor = .clear
        view.textAlignment = .center
        view.font = UIFont.systemFont(ofSize: 12, weight: .regular)
        view.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        return view
    }()
    
    lazy var chargeView : UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "Group_1171275120")
        return view
    }()
    
    lazy var startButton : UIButton = {
        let view = UIButton()
        view.setTitle("Go to Animations", for: .normal)
        view.backgroundColor = UIColor(red: 0.15, green: 0.42, blue: 1, alpha: 1)
        view.setTitleColor(.white, for: .normal)
        view.clipsToBounds = true
        view.layer.cornerRadius = 25
        view.addTarget(self, action: #selector(closeCurrentPage), for: .touchUpInside)
        return view
    }()
    
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        
        
        self.addSubview(self.backView)
        self.addSubview(self.startButton)
        self.addSubview(self.tipTitleLabel)
        self.addSubview(self.detailTipTitleLabel)
        self.addSubview(self.chargeView)
        
        
        
        self.backView.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
        self.tipTitleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(statusBarHeight + 44)
            make.left.equalToSuperview().offset(30)
            make.right.equalToSuperview().offset(-30)
            make.height.equalTo(50)
        }
        self.detailTipTitleLabel.snp.makeConstraints { make in
            make.top.equalTo(self.tipTitleLabel.snp.bottom).offset(4)
            make.height.equalTo(34)
            make.left.equalToSuperview().offset(30)
            make.right.equalToSuperview().offset(-30)
        }
        
        self.startButton.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.bottom.equalToSuperview().offset(-safeHeight-37)
            make.height.equalTo(50)
        }
        
        self.chargeView.snp.makeConstraints { make in
            make.top.equalTo(self.detailTipTitleLabel.snp.bottom).offset(42)
            make.height.equalTo(445 * RScreenH())
            make.width.equalTo(338 * RScreenH())
            make.centerX.equalToSuperview()
            
        }
    }
    @objc func closeCurrentPage(){
        let vc = self.responderViewController()?.navigationController?.viewControllers.first
        vc?.dismiss(animated: true)
//        self.responderViewController()?.navigationController?.popViewController(animated: true)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
